/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call.qrcode;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yoti.api.client.shareurl.DynamicScenario;
import com.yoti.api.client.shareurl.DynamicShareException;
import com.yoti.api.client.shareurl.ShareUrlResult;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestBuilderFactory;
import com.yoti.api.client.spi.remote.call.factory.UnsignedPathFactory;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicSharingService {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicSharingService.class);
    private final UnsignedPathFactory unsignedPathFactory;
    private final ObjectMapper objectMapper;
    private final SignedRequestBuilderFactory signedRequestBuilderFactory;
    private final String apiUrl;

    public static DynamicSharingService newInstance() {
        return new DynamicSharingService(new UnsignedPathFactory(), new ObjectMapper(), new SignedRequestBuilderFactory());
    }

    DynamicSharingService(UnsignedPathFactory unsignedPathFactory, ObjectMapper objectMapper, SignedRequestBuilderFactory signedRequestBuilderFactory) {
        this.unsignedPathFactory = unsignedPathFactory;
        this.objectMapper = objectMapper;
        this.signedRequestBuilderFactory = signedRequestBuilderFactory;
        this.apiUrl = System.getProperty("yoti.api.url", "https://api.yoti.com/api/v1");
    }

    public ShareUrlResult createShareUrl(String appId, KeyPair keyPair, DynamicScenario dynamicScenario) throws DynamicShareException {
        Validation.notNull(appId, "Application id");
        Validation.notNull(keyPair, "Application key Pair");
        Validation.notNull(dynamicScenario, "Dynamic scenario");
        String path = this.unsignedPathFactory.createDynamicSharingPath(appId);
        LOG.info("Requesting Dynamic QR Code at {}", (Object)path);
        try {
            byte[] body = this.objectMapper.writeValueAsString((Object)dynamicScenario).getBytes("UTF-8");
            SignedRequest signedRequest = this.createSignedRequest(keyPair, path, body);
            return signedRequest.execute(ShareUrlResult.class);
        }
        catch (ResourceException ex) {
            throw new DynamicShareException("Error posting the request: ", ex);
        }
        catch (IOException ex) {
            throw new DynamicShareException("Error building the request: ", ex);
        }
    }

    SignedRequest createSignedRequest(KeyPair keyPair, String path, byte[] body) throws DynamicShareException {
        try {
            return this.signedRequestBuilderFactory.create().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withPayload(body).withHttpMethod("POST").build();
        }
        catch (GeneralSecurityException ex) {
            throw new DynamicShareException("Error signing the request: ", ex);
        }
        catch (UnsupportedEncodingException | URISyntaxException ex) {
            throw new DynamicShareException("Error building the request: ", ex);
        }
    }
}

