/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.extension;

import com.yoti.api.client.shareurl.extension.Extension;
import com.yoti.api.client.shareurl.extension.LocationConstraintContent;
import com.yoti.api.client.shareurl.extension.LocationConstraintExtensionBuilder;
import com.yoti.api.client.shareurl.extension.SimpleExtension;
import com.yoti.api.client.spi.remote.util.Validation;

public class SimpleLocationConstraintExtensionBuilder
implements LocationConstraintExtensionBuilder {
    private double latitude;
    private double longitude;
    private double radius = 150.0;
    private double maxUncertainty = 150.0;

    public LocationConstraintExtensionBuilder withLatitude(double latitude) {
        Validation.withinRange(latitude, -90.0, 90.0, "latitude");
        this.latitude = latitude;
        return this;
    }

    public LocationConstraintExtensionBuilder withLongitude(double longitude) {
        Validation.withinRange(longitude, -180.0, 180.0, "longitude");
        this.longitude = longitude;
        return this;
    }

    public LocationConstraintExtensionBuilder withRadius(double radius) {
        Validation.notLessThan(radius, 0.0, "radius");
        this.radius = radius;
        return this;
    }

    public LocationConstraintExtensionBuilder withMaxUncertainty(double maxUncertainty) {
        Validation.notLessThan(maxUncertainty, 0.0, "maxUncertainty");
        this.maxUncertainty = maxUncertainty;
        return this;
    }

    public Extension<LocationConstraintContent> build() {
        LocationConstraintContent content = new LocationConstraintContent(this.latitude, this.longitude, this.radius, this.maxUncertainty);
        return new SimpleExtension<LocationConstraintContent>("LOCATION_CONSTRAINT", content);
    }
}

