/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.extension;

import com.yoti.api.client.AttributeDefinition;
import com.yoti.api.client.shareurl.extension.Extension;
import com.yoti.api.client.shareurl.extension.SimpleExtension;
import com.yoti.api.client.shareurl.extension.ThirdPartyAttributeContent;
import com.yoti.api.client.shareurl.extension.ThirdPartyAttributeExtensionBuilder;
import com.yoti.api.client.spi.remote.SimpleAttributeDefinition;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SimpleThirdPartyAttributeExtensionBuilder
implements ThirdPartyAttributeExtensionBuilder {
    private Date expiryDate;
    private List<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>();

    public ThirdPartyAttributeExtensionBuilder withExpiryDate(Date expiryDate) {
        Validation.notNull(expiryDate, "expiryDate");
        this.expiryDate = expiryDate;
        return this;
    }

    public ThirdPartyAttributeExtensionBuilder withDefinition(String definition) {
        Validation.notNullOrEmpty(definition, "definition");
        this.definitions.add(new SimpleAttributeDefinition(definition));
        return this;
    }

    public ThirdPartyAttributeExtensionBuilder withDefinitions(List<String> definitions) {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        for (String definition : definitions) {
            attributeDefinitions.add(new SimpleAttributeDefinition(definition));
        }
        this.definitions = attributeDefinitions;
        return this;
    }

    public Extension<ThirdPartyAttributeContent> build() {
        ThirdPartyAttributeContent thirdPartyAttributeContent = new ThirdPartyAttributeContent(this.expiryDate, this.definitions);
        return new SimpleExtension<ThirdPartyAttributeContent>("THIRD_PARTY_ATTRIBUTE", thirdPartyAttributeContent);
    }
}

