/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.policy;

import com.yoti.api.client.shareurl.constraint.Constraint;
import com.yoti.api.client.shareurl.policy.DynamicPolicy;
import com.yoti.api.client.shareurl.policy.DynamicPolicyBuilder;
import com.yoti.api.client.shareurl.policy.SimpleDynamicPolicy;
import com.yoti.api.client.shareurl.policy.SimpleWantedAttributeBuilder;
import com.yoti.api.client.shareurl.policy.WantedAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleDynamicPolicyBuilder
extends DynamicPolicyBuilder {
    private static final int SELFIE_AUTH_TYPE = 1;
    private static final int PIN_AUTH_TYPE = 2;
    private final Map<String, WantedAttribute> wantedAttributes = new HashMap<String, WantedAttribute>();
    private final Set<Integer> wantedAuthTypes = new HashSet<Integer>();
    private boolean wantedRememberMe;
    private boolean wantedRememberMeOptional;

    protected DynamicPolicyBuilder createDynamicPolicyBuilder() {
        return new SimpleDynamicPolicyBuilder();
    }

    public DynamicPolicyBuilder withWantedAttribute(WantedAttribute wantedAttribute) {
        String key = wantedAttribute.getDerivation() != null ? wantedAttribute.getDerivation() : wantedAttribute.getName();
        this.wantedAttributes.put(key, wantedAttribute);
        return this;
    }

    public DynamicPolicyBuilder withWantedAttribute(boolean optional, String name, List<Constraint> constraints) {
        WantedAttribute wantedAttribute = new SimpleWantedAttributeBuilder().withName(name).withOptional(optional).withConstraints(constraints).build();
        return this.withWantedAttribute(wantedAttribute);
    }

    public DynamicPolicyBuilder withWantedAttribute(boolean optional, String name) {
        return this.withWantedAttribute(optional, name, Collections.emptyList());
    }

    public DynamicPolicyBuilder withFamilyName() {
        return this.withFamilyName(false);
    }

    public DynamicPolicyBuilder withFamilyName(boolean optional) {
        return this.withWantedAttribute(optional, "family_name");
    }

    public DynamicPolicyBuilder withGivenNames() {
        return this.withGivenNames(false);
    }

    public DynamicPolicyBuilder withGivenNames(boolean optional) {
        return this.withWantedAttribute(optional, "given_names");
    }

    public DynamicPolicyBuilder withFullName() {
        return this.withFullName(false);
    }

    public DynamicPolicyBuilder withFullName(boolean optional) {
        return this.withWantedAttribute(optional, "full_name");
    }

    public DynamicPolicyBuilder withDateOfBirth() {
        return this.withDateOfBirth(false);
    }

    public DynamicPolicyBuilder withDateOfBirth(boolean optional) {
        return this.withWantedAttribute(optional, "date_of_birth");
    }

    public DynamicPolicyBuilder withAgeOver(int age) {
        return this.withAgeOver(false, age);
    }

    public DynamicPolicyBuilder withAgeOver(boolean optional, int age) {
        return this.withAgeDerivedAttribute(optional, "age_over:" + age);
    }

    public DynamicPolicyBuilder withAgeUnder(int age) {
        return this.withAgeUnder(false, age);
    }

    public DynamicPolicyBuilder withAgeUnder(boolean optional, int age) {
        return this.withAgeDerivedAttribute(optional, "age_under:" + age);
    }

    private DynamicPolicyBuilder withAgeDerivedAttribute(boolean optional, String derivation) {
        WantedAttribute wantedAttribute = new SimpleWantedAttributeBuilder().withName("date_of_birth").withDerivation(derivation).withOptional(optional).build();
        return this.withWantedAttribute(wantedAttribute);
    }

    public DynamicPolicyBuilder withGender() {
        return this.withGender(false);
    }

    public DynamicPolicyBuilder withGender(boolean optional) {
        return this.withWantedAttribute(optional, "gender");
    }

    public DynamicPolicyBuilder withPostalAddress() {
        return this.withPostalAddress(false);
    }

    public DynamicPolicyBuilder withPostalAddress(boolean optional) {
        return this.withWantedAttribute(optional, "postal_address");
    }

    public DynamicPolicyBuilder withStructuredPostalAddress() {
        return this.withStructuredPostalAddress(false);
    }

    public DynamicPolicyBuilder withStructuredPostalAddress(boolean optional) {
        return this.withWantedAttribute(optional, "structured_postal_address");
    }

    public DynamicPolicyBuilder withNationality() {
        return this.withNationality(false);
    }

    public DynamicPolicyBuilder withNationality(boolean optional) {
        return this.withWantedAttribute(optional, "nationality");
    }

    public DynamicPolicyBuilder withPhoneNumber() {
        return this.withPhoneNumber(false);
    }

    public DynamicPolicyBuilder withPhoneNumber(boolean optional) {
        return this.withWantedAttribute(optional, "phone_number");
    }

    public DynamicPolicyBuilder withSelfie() {
        return this.withSelfie(false);
    }

    public DynamicPolicyBuilder withSelfie(boolean optional) {
        return this.withWantedAttribute(optional, "selfie");
    }

    public DynamicPolicyBuilder withEmail() {
        return this.withEmail(false);
    }

    public DynamicPolicyBuilder withEmail(boolean optional) {
        return this.withWantedAttribute(optional, "email_address");
    }

    @Deprecated
    public DynamicPolicyBuilder withSelfieAuthorisation() {
        return this.withSelfieAuthorisation(true);
    }

    public DynamicPolicyBuilder withSelfieAuthorisation(boolean enabled) {
        return this.withWantedAuthType(1, enabled);
    }

    @Deprecated
    public DynamicPolicyBuilder withPinAuthorisation() {
        return this.withPinAuthorisation(true);
    }

    public DynamicPolicyBuilder withPinAuthorisation(boolean enabled) {
        return this.withWantedAuthType(2, enabled);
    }

    public DynamicPolicyBuilder withWantedAuthType(int wantedAuthType) {
        this.wantedAuthTypes.add(wantedAuthType);
        return this;
    }

    public DynamicPolicyBuilder withWantedAuthType(int wantedAuthType, boolean enabled) {
        if (enabled) {
            return this.withWantedAuthType(wantedAuthType);
        }
        this.wantedAuthTypes.remove(wantedAuthType);
        return this;
    }

    public DynamicPolicyBuilder withWantedRememberMe(boolean wantedRememberMe) {
        this.wantedRememberMe = wantedRememberMe;
        return this;
    }

    public DynamicPolicyBuilder withWantedRememberMeOptional(boolean wantedRememberMeOptional) {
        this.wantedRememberMeOptional = wantedRememberMeOptional;
        return this;
    }

    public DynamicPolicy build() {
        return new SimpleDynamicPolicy(this.wantedAttributes.values(), this.wantedAuthTypes, this.wantedRememberMe, this.wantedRememberMeOptional);
    }
}

