/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.shareurl.policy;

import com.yoti.api.client.shareurl.constraint.Constraint;
import com.yoti.api.client.shareurl.policy.SimpleWantedAttribute;
import com.yoti.api.client.shareurl.policy.WantedAttribute;
import com.yoti.api.client.shareurl.policy.WantedAttributeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleWantedAttributeBuilder
extends WantedAttributeBuilder {
    private String name;
    private String derivation;
    private boolean optional;
    private boolean acceptSelfAsserted;
    private List<Constraint> constraints = new ArrayList<Constraint>();

    protected WantedAttributeBuilder createWantedAttributeBuilder() {
        return new SimpleWantedAttributeBuilder();
    }

    public WantedAttributeBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public WantedAttributeBuilder withDerivation(String derivation) {
        this.derivation = derivation;
        return this;
    }

    public WantedAttributeBuilder withOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public WantedAttributeBuilder withAcceptSelfAsserted(boolean acceptSelfAsserted) {
        this.acceptSelfAsserted = acceptSelfAsserted;
        return this;
    }

    public WantedAttributeBuilder withConstraints(List<Constraint> constraints) {
        this.constraints = Collections.unmodifiableList(constraints);
        return this;
    }

    public WantedAttributeBuilder withConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public WantedAttribute build() {
        return new SimpleWantedAttribute(this.name, this.derivation, this.optional, this.acceptSelfAsserted, this.constraints);
    }
}

