/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.yoti.api.client.Anchor;
import com.yoti.api.client.Attribute;
import com.yoti.api.client.Image;
import com.yoti.api.client.spi.remote.AnchorConverter;
import com.yoti.api.client.spi.remote.DateValue;
import com.yoti.api.client.spi.remote.DocumentDetailsAttributeParser;
import com.yoti.api.client.spi.remote.JpegAttributeValue;
import com.yoti.api.client.spi.remote.PngAttributeValue;
import com.yoti.api.client.spi.remote.SimpleAttribute;
import com.yoti.api.client.spi.remote.proto.AttrProto;
import com.yoti.api.client.spi.remote.proto.ContentTypeProto;
import com.yoti.api.client.spi.remote.util.AnchorType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeConverter {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(AttributeConverter.class);
    private final DocumentDetailsAttributeParser documentDetailsAttributeParser;
    private final AnchorConverter anchorConverter;

    private AttributeConverter(DocumentDetailsAttributeParser documentDetailsAttributeParser, AnchorConverter anchorConverter) {
        this.documentDetailsAttributeParser = documentDetailsAttributeParser;
        this.anchorConverter = anchorConverter;
    }

    static final AttributeConverter newInstance() {
        return new AttributeConverter(new DocumentDetailsAttributeParser(), new AnchorConverter());
    }

    <T> Attribute<T> convertAttribute(AttrProto.Attribute attribute) throws ParseException, IOException {
        Object value = this.convertValueFromProto(attribute);
        value = this.convertSpecialType(attribute, value);
        List<Anchor> anchors = this.convertAnchors(attribute);
        List<Anchor> sources = this.filterAnchors(anchors, AnchorType.SOURCE.name());
        List<Anchor> verifiers = this.filterAnchors(anchors, AnchorType.VERIFIER.name());
        return new SimpleAttribute<Object>(attribute.getName(), value, sources, verifiers, anchors);
    }

    private Object convertValueFromProto(AttrProto.Attribute attribute) throws ParseException, IOException {
        return this.convertValue(attribute.getContentType(), attribute.getValue());
    }

    private Object convertValue(ContentTypeProto.ContentType contentType, ByteString value) throws ParseException, IOException {
        boolean isInvalid;
        boolean bl = isInvalid = contentType != ContentTypeProto.ContentType.STRING && value.isEmpty();
        if (isInvalid) {
            throw new ParseException("Only STRING attributes can have an empty value", 0);
        }
        switch (contentType) {
            case STRING: {
                return value.toString("UTF-8");
            }
            case DATE: {
                return DateValue.parseFrom(value.toByteArray());
            }
            case JPEG: {
                return new JpegAttributeValue(value.toByteArray());
            }
            case PNG: {
                return new PngAttributeValue(value.toByteArray());
            }
            case JSON: {
                return JSON_MAPPER.readValue(value.toString("UTF-8"), Map.class);
            }
            case MULTI_VALUE: {
                return this.convertMultiValue(value);
            }
            case INT: {
                return Integer.parseInt(value.toString("UTF-8"));
            }
        }
        LOG.warn("Unknown type '{}', attempting to parse it as a String", (Object)contentType);
        return value.toString("UTF-8");
    }

    private List<Object> convertMultiValue(ByteString value) throws IOException, ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (AttrProto.MultiValue.Value thisValue : AttrProto.MultiValue.parseFrom(value).getValuesList()) {
            Object o = this.convertValue(thisValue.getContentType(), thisValue.getData());
            list.add(o);
        }
        return list;
    }

    private Object convertSpecialType(AttrProto.Attribute attribute, Object value) throws UnsupportedEncodingException, ParseException {
        switch (attribute.getName()) {
            case "document_details": {
                return this.documentDetailsAttributeParser.parseFrom((String)value);
            }
            case "document_images": {
                return this.filterForType((List)value, Image.class, "document_images");
            }
        }
        return value;
    }

    private <T> List<T> filterForType(List<Object> values, Class<T> clazz, String attributeName) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            if (clazz.isInstance(value)) {
                list.add(value);
                continue;
            }
            LOG.warn("Filtering out unexpected instance of '{}' from '{}' multi-value", (Object)value.getClass().getCanonicalName(), (Object)attributeName);
        }
        return Collections.unmodifiableList(list);
    }

    private List<Anchor> convertAnchors(AttrProto.Attribute attrProto) {
        ArrayList<Anchor> entries = new ArrayList<Anchor>();
        for (AttrProto.Anchor anchorProto : attrProto.getAnchorsList()) {
            try {
                entries.add(this.anchorConverter.convert(anchorProto));
            }
            catch (Exception e) {
                LOG.warn("Failed to read '{}' Anchor for Attribute '{}'", (Object)anchorProto.getSubType(), (Object)attrProto.getName());
                LOG.debug("Converting Anchor on Attribute '{}' resulted in exception '{}'", (Object)attrProto.getName(), (Object)e);
            }
        }
        return Collections.unmodifiableList(entries);
    }

    private List<Anchor> filterAnchors(List<Anchor> anchors, String type) {
        ArrayList<Anchor> filtered = new ArrayList<Anchor>();
        for (Anchor anchor : anchors) {
            if (!type.equals(anchor.getType())) continue;
            filtered.add(anchor);
        }
        return Collections.unmodifiableList(filtered);
    }
}

