/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Date;
import com.yoti.api.client.DateTime;
import com.yoti.api.client.Time;
import com.yoti.api.client.spi.remote.DateValue;
import com.yoti.api.client.spi.remote.TimeValue;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeValue
implements DateTime {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private final Date date;
    private final Time time;

    public DateTimeValue(Date date, Time time) {
        Validation.notNull(date, "date");
        Validation.notNull(time, "time");
        this.date = date;
        this.time = time;
    }

    public static DateTimeValue from(long microseconds) {
        Calendar calendar = GregorianCalendar.getInstance(UTC_TIME_ZONE);
        int mod = (int)(microseconds % 1000L);
        long milliseconds = (microseconds - (long)mod) / 1000L;
        calendar.setTimeInMillis(milliseconds);
        return new DateTimeValue(DateValue.from(calendar), TimeValue.from(calendar, mod));
    }

    public Date getDate() {
        return this.date;
    }

    public Time getTime() {
        return this.time;
    }

    public String toString() {
        return String.format("DateTimeValue{date=%s,time=%s}", this.date, this.time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeValue that = (DateTimeValue)o;
        return this.date.equals(that.date) && this.time.equals(that.time);
    }

    public int hashCode() {
        int result = this.date != null ? this.date.hashCode() : 0;
        result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
        return result;
    }
}

