/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Date;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public final class DateValue
implements Date {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private final int year;
    private final int month;
    private final int day;

    private DateValue(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static DateValue from(Calendar calendar) {
        return new DateValue(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static DateValue parseFrom(byte[] content) throws UnsupportedEncodingException, ParseException {
        String source = new String(content, "UTF-8");
        return DateValue.parseFrom(source);
    }

    public static DateValue parseFrom(String source) throws UnsupportedEncodingException, ParseException {
        Calendar calendar = DateValue.parseDate(source);
        return DateValue.from(calendar);
    }

    private static Calendar parseDate(String source) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
        simpleDateFormat.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(source));
        return calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateValue dateValue = (DateValue)o;
        if (this.year != dateValue.year) {
            return false;
        }
        if (this.month != dateValue.month) {
            return false;
        }
        return this.day == dateValue.day;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        return result;
    }

    public static DateValueBuilder builder() {
        return new DateValueBuilder();
    }

    public static class DateValueBuilder {
        private int year = 1;
        private int month = 1;
        private int day = 1;

        private DateValueBuilder() {
        }

        public DateValueBuilder withYear(int year) {
            Validation.notEqualTo(year, 0, "year");
            this.year = year;
            return this;
        }

        public DateValueBuilder withMonth(int month) {
            Validation.withinRange(month, 1, 12, "month");
            this.month = month;
            return this;
        }

        public DateValueBuilder withDay(int day) {
            Validation.withinRange(day, 1, 31, "day");
            this.day = day;
            return this;
        }

        public DateValue build() {
            try {
                return DateValue.parseFrom(String.format("%s-%s-%s", this.year, this.month, this.day));
            }
            catch (UnsupportedEncodingException | ParseException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

