/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Date;
import com.yoti.api.client.DocumentDetails;
import com.yoti.api.client.spi.remote.DateValue;
import com.yoti.api.client.spi.remote.DocumentDetailsAttributeValue;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

class DocumentDetailsAttributeParser {
    private static final String MINIMUM_ACCEPTABLE = "([A-Za-z_]*) ([A-Za-z]{3}) ([A-Za-z0-9]{1}).*";
    private static final int TYPE_INDEX = 0;
    private static final int COUNTRY_INDEX = 1;
    private static final int NUMBER_INDEX = 2;
    private static final int EXPIRATION_INDEX = 3;
    private static final int AUTHORITY_INDEX = 4;

    DocumentDetailsAttributeParser() {
    }

    DocumentDetails parseFrom(String attributeValue) throws UnsupportedEncodingException, ParseException {
        if (attributeValue == null || !attributeValue.matches(MINIMUM_ACCEPTABLE)) {
            throw new IllegalArgumentException("Unable to parse attribute value to a DocumentDetails");
        }
        String[] attributes = attributeValue.split(" ");
        return DocumentDetailsAttributeValue.builder().withType(attributes[0]).withIssuingCountry(attributes[1]).withNumber(attributes[2]).withDate(DocumentDetailsAttributeParser.getDateSafely(attributes, 3)).withAuthority(DocumentDetailsAttributeParser.getSafely(attributes, 4)).build();
    }

    private static Date getDateSafely(String[] attributes, int index) throws UnsupportedEncodingException, ParseException {
        String expirationDate = DocumentDetailsAttributeParser.getSafely(attributes, index);
        return expirationDate == null ? null : DateValue.parseFrom(expirationDate);
    }

    private static String getSafely(String[] attributes, int index) {
        String value = attributes.length > index ? attributes[index] : null;
        return "-".equals(value) ? null : value;
    }
}

