/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yoti.api.client.ProfileException;
import com.yoti.api.client.spi.remote.proto.EncryptedDataProto;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public class EncryptedDataReader {
    private EncryptedDataReader() {
    }

    static EncryptedDataReader newInstance() {
        return new EncryptedDataReader();
    }

    public byte[] decryptBytes(byte[] encryptedBytes, Key secretKey) throws ProfileException {
        EncryptedDataProto.EncryptedData encryptedData = this.parseEncryptedContent(encryptedBytes);
        return this.decrypt(encryptedData, secretKey);
    }

    private EncryptedDataProto.EncryptedData parseEncryptedContent(byte[] encryptedBytes) throws ProfileException {
        try {
            return EncryptedDataProto.EncryptedData.parseFrom(encryptedBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProfileException("Cannot decode profile", (Throwable)e);
        }
    }

    private byte[] decrypt(EncryptedDataProto.EncryptedData encryptedData, Key secretKey) throws ProfileException {
        ByteString initVector = encryptedData.getIv();
        if (initVector == null || initVector.size() == 0) {
            throw new ProfileException("Receipt key IV must not be null.");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            cipher.init(2, secretKey, new IvParameterSpec(initVector.toByteArray()));
            return cipher.doFinal(encryptedData.getCipherText().toByteArray());
        }
        catch (GeneralSecurityException gse) {
            throw new ProfileException("Error decrypting data", (Throwable)gse);
        }
        catch (IllegalArgumentException iae) {
            throw new ProfileException("Base64 encoding error", (Throwable)iae);
        }
    }
}

