/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.AgeVerification;
import com.yoti.api.client.Attribute;
import com.yoti.api.client.Date;
import com.yoti.api.client.DocumentDetails;
import com.yoti.api.client.HumanProfile;
import com.yoti.api.client.Image;
import com.yoti.api.client.Profile;
import com.yoti.api.client.spi.remote.SimpleAgeVerification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class HumanProfileAdapter
implements HumanProfile {
    private final Profile wrapped;
    private Map<String, AgeVerification> verificationsMap;

    private HumanProfileAdapter(Profile wrapped) {
        this.wrapped = wrapped;
    }

    public static HumanProfile wrap(Profile wrapped) {
        return new HumanProfileAdapter(wrapped);
    }

    public Attribute getAttribute(String name) {
        return this.wrapped.getAttribute(name);
    }

    public <T> Attribute<T> getAttribute(String name, Class<T> clazz) {
        return this.wrapped.getAttribute(name, clazz);
    }

    public <T> List<Attribute<T>> findAttributesStartingWith(String name, Class<T> clazz) {
        return this.wrapped.findAttributesStartingWith(name, clazz);
    }

    public <T> Attribute<T> findAttributeStartingWith(String name, Class<T> clazz) {
        return this.wrapped.findAttributeStartingWith(name, clazz);
    }

    public Collection<Attribute<?>> getAttributes() {
        return this.wrapped.getAttributes();
    }

    public Attribute<String> getFamilyName() {
        return this.wrapped.getAttribute("family_name", String.class);
    }

    public Attribute<String> getGivenNames() {
        return this.wrapped.getAttribute("given_names", String.class);
    }

    public Attribute<String> getFullName() {
        return this.wrapped.getAttribute("full_name", String.class);
    }

    public Attribute<Date> getDateOfBirth() {
        return this.wrapped.getAttribute("date_of_birth", Date.class);
    }

    public List<AgeVerification> getAgeVerifications() {
        this.findAllAgeVerifications();
        return Collections.unmodifiableList(new ArrayList<AgeVerification>(this.verificationsMap.values()));
    }

    public AgeVerification findAgeOverVerification(int age) {
        this.findAllAgeVerifications();
        return this.verificationsMap.get("age_over:" + age);
    }

    public AgeVerification findAgeUnderVerification(int age) {
        this.findAllAgeVerifications();
        return this.verificationsMap.get("age_under:" + age);
    }

    private void findAllAgeVerifications() {
        if (this.verificationsMap == null) {
            HashMap<String, AgeVerification> verifications = new HashMap<String, AgeVerification>();
            for (Attribute ageOver : this.wrapped.findAttributesStartingWith("age_over:", String.class)) {
                verifications.put(ageOver.getName(), new SimpleAgeVerification((Attribute<String>)ageOver));
            }
            for (Attribute ageUnder : this.wrapped.findAttributesStartingWith("age_under:", String.class)) {
                verifications.put(ageUnder.getName(), new SimpleAgeVerification((Attribute<String>)ageUnder));
            }
            this.verificationsMap = verifications;
        }
    }

    @Deprecated
    public Boolean isAgeVerified() {
        Boolean isAgeOver = this.parseFromStringAttribute((Attribute<String>)this.wrapped.findAttributeStartingWith("age_over:", String.class));
        Boolean isAgeUnder = this.parseFromStringAttribute((Attribute<String>)this.wrapped.findAttributeStartingWith("age_under:", String.class));
        return isAgeOver != null ? isAgeOver : isAgeUnder;
    }

    public Attribute<String> getGender() {
        return this.wrapped.getAttribute("gender", String.class);
    }

    public Attribute<String> getPostalAddress() {
        return this.wrapped.getAttribute("postal_address", String.class);
    }

    public Attribute<Map<?, ?>> getStructuredPostalAddress() {
        return this.wrapped.getAttribute("structured_postal_address", Map.class);
    }

    public Attribute<String> getNationality() {
        return this.wrapped.getAttribute("nationality", String.class);
    }

    public Attribute<String> getPhoneNumber() {
        return this.wrapped.getAttribute("phone_number", String.class);
    }

    public Attribute<Image> getSelfie() {
        return this.wrapped.getAttribute("selfie", Image.class);
    }

    public Attribute<String> getEmailAddress() {
        return this.wrapped.getAttribute("email_address", String.class);
    }

    public Attribute<DocumentDetails> getDocumentDetails() {
        return this.wrapped.getAttribute("document_details", DocumentDetails.class);
    }

    public Attribute<List<Image>> getDocumentImages() {
        Attribute a = this.wrapped.getAttribute("document_images", List.class);
        return a;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HumanProfileAdapter other = (HumanProfileAdapter)obj;
        return !(this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped));
    }

    private Boolean parseFromStringAttribute(Attribute<String> attribute) {
        return attribute == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)attribute.getValue()));
    }
}

