/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.InitialisationException;
import com.yoti.api.client.KeyPairSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class KeyStreamVisitor
implements KeyPairSource.StreamVisitor {
    public KeyPair accept(InputStream stream) throws IOException, InitialisationException {
        PEMParser reader = new PEMParser((Reader)new BufferedReader(new InputStreamReader(stream, "UTF-8")));
        KeyPair keyPair = this.findKeyPair(reader);
        if (keyPair == null) {
            throw new InitialisationException("No key pair found in the provided source");
        }
        return keyPair;
    }

    KeyPair findKeyPair(PEMParser reader) throws IOException {
        Object o;
        while ((o = reader.readObject()) != null) {
            if (!(o instanceof PEMKeyPair)) continue;
            return new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)o);
        }
        return null;
    }
}

