/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.ActivityDetails;
import com.yoti.api.client.ApplicationProfile;
import com.yoti.api.client.ExtraData;
import com.yoti.api.client.HumanProfile;
import com.yoti.api.client.Image;
import com.yoti.api.client.Profile;
import com.yoti.api.client.spi.remote.ApplicationProfileAdapter;
import com.yoti.api.client.spi.remote.HumanProfileAdapter;
import com.yoti.api.client.spi.remote.SimpleExtraData;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.Date;
import org.bouncycastle.util.encoders.Base64;

final class SimpleActivityDetails
implements ActivityDetails {
    private final String rememberMeId;
    private final String parentRememberMeId;
    private final ApplicationProfile applicationProfile;
    private final HumanProfile userProfile;
    private final Date timestamp;
    private final String receiptId;
    private final String base64Selfie;
    private final ExtraData extraData;

    @Deprecated
    public SimpleActivityDetails(String rememberMeId, String parentRememberMeId, Profile userProfile, Profile applicationProfile, Date timestamp, byte[] receiptId) {
        this(rememberMeId, parentRememberMeId, userProfile, applicationProfile, new SimpleExtraData(), timestamp, receiptId);
    }

    public SimpleActivityDetails(String rememberMeId, String parentRememberMeId, Profile userProfile, Profile applicationProfile, ExtraData extraData, Date timestamp, byte[] receiptId) {
        this.rememberMeId = Validation.notNull(rememberMeId, "Remember Me id");
        this.parentRememberMeId = parentRememberMeId;
        this.userProfile = HumanProfileAdapter.wrap(Validation.notNull(userProfile, "User profile"));
        this.applicationProfile = ApplicationProfileAdapter.wrap(Validation.notNull(applicationProfile, "Application profile"));
        this.timestamp = Validation.notNull(timestamp, "Timestamp");
        this.receiptId = Base64.toBase64String((byte[])Validation.notNull(receiptId, "Receipt id"));
        this.base64Selfie = this.userProfile.getSelfie() != null ? "data:image/jpeg;base64," + Base64.toBase64String((byte[])((Image)this.userProfile.getSelfie().getValue()).getContent()) : "";
        this.extraData = Validation.notNull(extraData, "extraData");
    }

    public HumanProfile getUserProfile() {
        return this.userProfile;
    }

    public ApplicationProfile getApplicationProfile() {
        return this.applicationProfile;
    }

    @Deprecated
    public String getUserId() {
        return this.getRememberMeId();
    }

    public String getRememberMeId() {
        return this.rememberMeId;
    }

    public String getParentRememberMeId() {
        return this.parentRememberMeId;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    public ExtraData getExtraData() {
        return this.extraData;
    }

    @Deprecated
    public String getBase64Selfie() {
        return this.base64Selfie;
    }
}

