/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.AgeVerification;
import com.yoti.api.client.Attribute;
import com.yoti.api.client.spi.remote.util.Validation;

public class SimpleAgeVerification
implements AgeVerification {
    private final Attribute<String> derivedAttribute;
    private final int ageVerified;
    private final String checkPerformed;
    private final boolean result;

    public SimpleAgeVerification(Attribute<String> derivedAttribute) {
        Validation.notNull(derivedAttribute, "derivedAttribute");
        Validation.matchesPattern(derivedAttribute.getName(), "[^:]+:(?!.*:)[0-9]+", "attribute.name");
        this.derivedAttribute = derivedAttribute;
        String[] split = derivedAttribute.getName().split(":");
        this.checkPerformed = split[0];
        this.ageVerified = Integer.parseInt(split[1]);
        this.result = Boolean.parseBoolean((String)derivedAttribute.getValue());
    }

    public int getAge() {
        return this.ageVerified;
    }

    public String getCheckType() {
        return this.checkPerformed;
    }

    public boolean getResult() {
        return this.result;
    }

    public Attribute<String> getAttribute() {
        return this.derivedAttribute;
    }
}

