/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Attribute;
import com.yoti.api.client.Profile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class SimpleProfile
implements Profile {
    private final Map<String, Attribute<?>> protectedAttributes;

    public SimpleProfile(List<Attribute<?>> attributeList) {
        if (attributeList == null) {
            throw new IllegalArgumentException("Attributes must not be null.");
        }
        this.protectedAttributes = Collections.unmodifiableMap(this.createAttributeMap(attributeList));
    }

    public <T> Attribute<T> getAttribute(String name, Class<T> clazz) {
        this.ensureName(name);
        Attribute<?> attribute = this.protectedAttributes.get(name);
        return this.castSafely(clazz, attribute);
    }

    public Attribute getAttribute(String name) {
        this.ensureName(name);
        return this.protectedAttributes.get(name);
    }

    public <T> List<Attribute<T>> findAttributesStartingWith(String name, Class<T> clazz) {
        this.ensureName(name);
        ArrayList<Attribute<T>> matches = new ArrayList<Attribute<T>>();
        for (Map.Entry<String, Attribute<?>> entry : this.protectedAttributes.entrySet()) {
            if (!entry.getKey().startsWith(name)) continue;
            Attribute<T> value = this.castSafely(clazz, entry.getValue());
            matches.add(value);
        }
        return matches;
    }

    public <T> Attribute<T> findAttributeStartingWith(String name, Class<T> clazz) {
        this.ensureName(name);
        Attribute<?> attribute = this.doFindAttribute(name);
        return this.castSafely(clazz, attribute);
    }

    public Collection<Attribute<?>> getAttributes() {
        return this.protectedAttributes.values();
    }

    private Map<String, Attribute<?>> createAttributeMap(List<Attribute<?>> attributes) {
        HashMap result = new HashMap();
        for (Attribute<?> a : attributes) {
            result.put(a.getName(), a);
        }
        return result;
    }

    private Attribute<?> doFindAttribute(String name) {
        this.ensureName(name);
        for (Map.Entry<String, Attribute<?>> entry : this.protectedAttributes.entrySet()) {
            if (!entry.getKey().startsWith(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void ensureName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name must not be null.");
        }
    }

    private <T> Attribute<T> castSafely(Class<T> clazz, Attribute<?> attribute) {
        Class<?> valueType;
        if (attribute != null && !clazz.isAssignableFrom(valueType = attribute.getValue().getClass())) {
            throw new ClassCastException(String.format("Cannot cast from '%s' to '%s'", valueType.getCanonicalName(), clazz.getCanonicalName()));
        }
        return attribute;
    }
}

