/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yoti.api.client.AttributeDefinition;
import com.yoti.api.client.AttributeIssuanceDetails;
import com.yoti.api.client.DateTime;
import com.yoti.api.client.ExtraDataException;
import com.yoti.api.client.spi.remote.Base64;
import com.yoti.api.client.spi.remote.DateTimeValue;
import com.yoti.api.client.spi.remote.SimpleAttributeDefinition;
import com.yoti.api.client.spi.remote.SimpleAttributeIssuanceDetails;
import com.yoti.api.client.spi.remote.proto.IssuingAttributesProto;
import com.yoti.api.client.spi.remote.proto.ThirdPartyAttributeProto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartyAttributeConverter {
    private static Logger LOG = LoggerFactory.getLogger(ThirdPartyAttributeConverter.class);

    public static ThirdPartyAttributeConverter newInstance() {
        return new ThirdPartyAttributeConverter();
    }

    public AttributeIssuanceDetails parseThirdPartyAttribute(byte[] value) throws InvalidProtocolBufferException, ExtraDataException {
        ThirdPartyAttributeProto.ThirdPartyAttribute thirdPartyAttribute = ThirdPartyAttributeProto.ThirdPartyAttribute.parseFrom(value);
        IssuingAttributes issuingAttributes = this.parseIssuingAttributes(thirdPartyAttribute.getIssuingAttributes());
        ByteString issuanceToken = thirdPartyAttribute.getIssuanceToken();
        String token = Base64.getEncoder().encodeToString(issuanceToken.toByteArray());
        DateTime expiryDate = issuingAttributes.getExpiryDate();
        List<AttributeDefinition> attributeDefinitions = issuingAttributes.getAttributeDefinitions();
        if (token.isEmpty()) {
            throw new ExtraDataException("ThirdPartyAttribute missing token");
        }
        return new SimpleAttributeIssuanceDetails(token, expiryDate, attributeDefinitions);
    }

    private IssuingAttributes parseIssuingAttributes(IssuingAttributesProto.IssuingAttributes issuingAttributes) {
        String expiryDateString = issuingAttributes.getExpiryDate();
        DateTimeValue expiryDate = this.parseExpiryDateTime(expiryDateString);
        List<IssuingAttributesProto.Definition> definitionProtoList = issuingAttributes.getDefinitionsList();
        List<AttributeDefinition> attributeDefinitions = this.parseDefinitions(definitionProtoList);
        return new IssuingAttributes(expiryDate, attributeDefinitions);
    }

    private DateTimeValue parseExpiryDateTime(String dateTimeStringValue) {
        if (dateTimeStringValue == null || dateTimeStringValue.isEmpty()) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateTimeValue dateTimeValue = null;
        try {
            Date date = simpleDateFormat.parse(dateTimeStringValue);
            dateTimeValue = DateTimeValue.from(date.getTime() * 1000L);
        }
        catch (ParseException e) {
            LOG.error("Failed to parse date: '{}', {}", (Object)dateTimeStringValue, (Object)e.getMessage());
        }
        return dateTimeValue;
    }

    private List<AttributeDefinition> parseDefinitions(List<IssuingAttributesProto.Definition> definitions) {
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        for (IssuingAttributesProto.Definition definition : definitions) {
            SimpleAttributeDefinition newDef = new SimpleAttributeDefinition(definition.getName());
            attributes.add(newDef);
        }
        return attributes;
    }

    static class IssuingAttributes {
        private DateTime expiryDate;
        private List<AttributeDefinition> attributeDefinitions;

        public IssuingAttributes(DateTime expiryDate, List<AttributeDefinition> attributeDefinitions) {
            this.expiryDate = expiryDate;
            this.attributeDefinitions = attributeDefinitions;
        }

        public DateTime getExpiryDate() {
            return this.expiryDate;
        }

        public List<AttributeDefinition> getAttributeDefinitions() {
            return this.attributeDefinitions;
        }
    }
}

