/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.Time;
import com.yoti.api.client.spi.remote.util.Validation;
import java.util.Calendar;

public class TimeValue
implements Time {
    private final int hour;
    private final int minute;
    private final int second;
    private final int microsecond;

    private TimeValue(int hour, int minute, int second, int microsecond) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
    }

    public static TimeValue from(Calendar calendar, int microsecond) {
        Validation.notGreaterThan(microsecond, 999, "microsecond");
        return new TimeValue(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000 + microsecond);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%06d", this.hour, this.minute, this.second, this.microsecond);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeValue timeValue = (TimeValue)o;
        if (this.hour != timeValue.hour) {
            return false;
        }
        if (this.minute != timeValue.minute) {
            return false;
        }
        if (this.second != timeValue.second) {
            return false;
        }
        return this.microsecond == timeValue.microsecond;
    }

    public int hashCode() {
        int result = this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.second;
        result = 31 * result + this.microsecond;
        return result;
    }

    public static TimeValueBuilder builder() {
        return new TimeValueBuilder();
    }

    public static class TimeValueBuilder {
        private int hour;
        private int minute;
        private int second;
        private int microsecond;

        private TimeValueBuilder() {
        }

        public TimeValueBuilder withHour(int hour) {
            Validation.withinRange(hour, 0, 23, "hour");
            this.hour = hour;
            return this;
        }

        public TimeValueBuilder withMinute(int minute) {
            Validation.withinRange(minute, 0, 59, "minute");
            this.minute = minute;
            return this;
        }

        public TimeValueBuilder withSecond(int second) {
            Validation.withinRange(second, 0, 59, "second");
            this.second = second;
            return this;
        }

        public TimeValueBuilder withMicrosecond(int microsecond) {
            Validation.withinRange(microsecond, 0, 999999, "microsecond");
            this.microsecond = microsecond;
            return this;
        }

        public TimeValue build() {
            return new TimeValue(this.hour, this.minute, this.second, this.microsecond);
        }
    }
}

