/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.yoti.api.client.Image;
import com.yoti.api.client.spi.remote.JpegAttributeValue;
import com.yoti.api.client.spi.remote.PngAttributeValue;
import com.yoti.api.client.spi.remote.call.RawResourceFetcher;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImageResourceFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ImageResourceFetcher.class);
    private final RawResourceFetcher rawResourceFetcher;

    public static ImageResourceFetcher newInstance(RawResourceFetcher rawResourceFetcher) {
        return new ImageResourceFetcher(rawResourceFetcher);
    }

    private ImageResourceFetcher(RawResourceFetcher rawResourceFetcher) {
        this.rawResourceFetcher = rawResourceFetcher;
    }

    Image doRequest(SignedRequest signedRequest) throws IOException, ResourceException {
        SignedRequestResponse signedRequestResponse = this.rawResourceFetcher.doRequest(signedRequest);
        String contentType = this.getContentType(signedRequestResponse.getResponseHeaders());
        byte[] responseBody = signedRequestResponse.getResponseBody();
        switch (contentType) {
            case "image/png": {
                return new PngAttributeValue(responseBody);
            }
            case "image/jpeg": {
                return new JpegAttributeValue(responseBody);
            }
        }
        LOG.error("Failed to convert image of type: (" + contentType + ")");
        throw new ResourceException(signedRequestResponse.getResponseCode(), "Failed to convert image of type: (" + contentType + ")", null);
    }

    private String getContentType(Map<String, List<String>> responseHeaders) {
        List<String> values = responseHeaders.get("Content-Type");
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

