/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yoti.api.client.spi.remote.call.RawResourceFetcher;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.ResourceFetcher;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestResponse;
import com.yoti.api.client.spi.remote.call.UrlConnector;
import java.io.IOException;
import java.util.Map;

public final class JsonResourceFetcher
implements ResourceFetcher {
    private final ObjectMapper objectMapper;
    private final RawResourceFetcher rawResourceFetcher;

    public static JsonResourceFetcher newInstance() {
        return JsonResourceFetcher.newInstance(new RawResourceFetcher());
    }

    public static JsonResourceFetcher newInstance(RawResourceFetcher rawResourceFetcher) {
        return new JsonResourceFetcher(new ObjectMapper(), rawResourceFetcher);
    }

    private JsonResourceFetcher(ObjectMapper objectMapper, RawResourceFetcher rawResourceFetcher) {
        this.objectMapper = objectMapper;
        this.rawResourceFetcher = rawResourceFetcher;
    }

    @Override
    @Deprecated
    public <T> T fetchResource(UrlConnector urlConnector, Map<String, String> headers, Class<T> resourceClass) throws ResourceException, IOException {
        return this.doRequest(urlConnector, "GET", null, headers, resourceClass);
    }

    @Override
    @Deprecated
    public <T> T postResource(UrlConnector urlConnector, byte[] body, Map<String, String> headers, Class<T> resourceClass) throws ResourceException, IOException {
        return this.doRequest(urlConnector, "POST", body, headers, resourceClass);
    }

    @Deprecated
    public <T> T doRequest(UrlConnector urlConnector, String httpMethod, byte[] body, Map<String, String> headers, Class<T> resourceClass) throws ResourceException, IOException {
        SignedRequestResponse signedRequestResponse = this.rawResourceFetcher.doRequest(urlConnector, httpMethod, body, headers);
        return (T)this.objectMapper.readValue(signedRequestResponse.getResponseBody(), resourceClass);
    }

    <T> T doRequest(SignedRequest signedRequest, Class<T> resourceClass) throws ResourceException, IOException {
        SignedRequestResponse signedRequestResponse = this.rawResourceFetcher.doRequest(signedRequest);
        return (T)this.objectMapper.readValue(signedRequestResponse.getResponseBody(), resourceClass);
    }
}

