/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestResponse;
import com.yoti.api.client.spi.remote.call.UrlConnector;
import com.yoti.api.client.spi.remote.util.QuietCloseable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RawResourceFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(RawResourceFetcher.class);

    RawResourceFetcher() {
    }

    private static Scanner createScanner(InputStream inputStream) {
        return new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
    }

    public SignedRequestResponse doRequest(SignedRequest signedRequest) throws IOException, ResourceException {
        UrlConnector urlConnector = UrlConnector.get(signedRequest.getUri().toString());
        return this.doRequest(urlConnector, signedRequest.getMethod(), signedRequest.getData(), signedRequest.getHeaders());
    }

    public SignedRequestResponse doRequest(UrlConnector urlConnector, String method, byte[] data, Map<String, String> headers) throws IOException, ResourceException {
        HttpURLConnection httpUrlConnection = this.openConnection(urlConnector, method, headers);
        this.sendBody(data, httpUrlConnection);
        return this.parseResponse(httpUrlConnection);
    }

    private HttpURLConnection openConnection(UrlConnector urlConnector, String httpMethod, Map<String, String> headers) throws IOException {
        LOG.debug("Connecting to: '{}'", (Object)urlConnector.getUrlString());
        HttpURLConnection httpUrlConnection = urlConnector.getHttpUrlConnection();
        httpUrlConnection.setRequestMethod(httpMethod);
        this.setHeaders(headers, httpUrlConnection);
        return httpUrlConnection;
    }

    private void setHeaders(Map<String, String> headers, HttpURLConnection con) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private void sendBody(byte[] body, HttpURLConnection httpUrlConnection) throws IOException {
        if (body != null) {
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.getOutputStream().write(body);
            httpUrlConnection.getOutputStream().close();
        }
    }

    private SignedRequestResponse parseResponse(HttpURLConnection httpUrlConnection) throws ResourceException, IOException {
        int responseCode = httpUrlConnection.getResponseCode();
        if (responseCode >= 400) {
            String responseBody = this.readError(httpUrlConnection);
            throw new ResourceException(responseCode, httpUrlConnection.getResponseMessage(), responseBody);
        }
        return new SignedRequestResponse(responseCode, this.readBody(httpUrlConnection), httpUrlConnection.getHeaderFields());
    }

    private String readError(HttpURLConnection httpURLConnection) {
        try (QuietCloseable<Scanner> scanner = new QuietCloseable<Scanner>(RawResourceFetcher.createScanner(httpURLConnection.getErrorStream()));){
            String string = scanner.get().hasNext() ? scanner.get().next() : "";
            return string;
        }
    }

    private byte[] readBody(HttpURLConnection httpURLConnection) throws IOException {
        try (QuietCloseable<InputStream> inputStream = new QuietCloseable<InputStream>(httpURLConnection.getInputStream());){
            byte[] byArray = this.readChunked(inputStream.get());
            return byArray;
        }
    }

    private byte[] readChunked(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byteChunk = new byte[4096];
        while ((n = inputStream.read(byteChunk)) > 0) {
            byteArrayOutputStream.write(byteChunk, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

