/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.yoti.api.client.ProfileException;
import com.yoti.api.client.spi.remote.Base64;
import com.yoti.api.client.spi.remote.call.ProfileResponse;
import com.yoti.api.client.spi.remote.call.ProfileService;
import com.yoti.api.client.spi.remote.call.Receipt;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestBuilder;
import com.yoti.api.client.spi.remote.call.factory.UnsignedPathFactory;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteProfileService
implements ProfileService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteProfileService.class);
    private final UnsignedPathFactory unsignedPathFactory;
    private final String apiUrl;

    public static RemoteProfileService newInstance() {
        return new RemoteProfileService(new UnsignedPathFactory());
    }

    RemoteProfileService(UnsignedPathFactory profilePathFactory) {
        this.unsignedPathFactory = profilePathFactory;
        this.apiUrl = System.getProperty("yoti.api.url", "https://api.yoti.com/api/v1");
    }

    @Override
    public Receipt getReceipt(KeyPair keyPair, String appId, String connectToken) throws ProfileException {
        Validation.notNull(keyPair, "Key pair");
        Validation.notNull(appId, "Application id");
        Validation.notNull(connectToken, "Connect token");
        String path = this.unsignedPathFactory.createProfilePath(appId, connectToken);
        try {
            String authKey = Base64.base64(keyPair.getPublic().getEncoded());
            SignedRequest signedRequest = this.createSignedRequest(keyPair, path, authKey);
            return this.fetchReceipt(signedRequest);
        }
        catch (IOException ioe) {
            throw new ProfileException("Error calling service to get profile", (Throwable)ioe);
        }
    }

    private Receipt fetchReceipt(SignedRequest signedRequest) throws IOException, ProfileException {
        LOG.info("Fetching profile from resource at '{}'", (Object)signedRequest.getUri());
        try {
            ProfileResponse response = signedRequest.execute(ProfileResponse.class);
            return response.getReceipt();
        }
        catch (ResourceException re) {
            int responseCode = re.getResponseCode();
            switch (responseCode) {
                case 500: {
                    throw new ProfileException("Error completing sharing: " + re.getResponseBody(), (Throwable)re);
                }
                case 404: {
                    throw new ProfileException("Profile not found. This can be due to a used or expired token. Details: " + re.getResponseBody(), (Throwable)re);
                }
            }
            throw new ProfileException("Unexpected response: " + responseCode + " " + re.getResponseBody(), (Throwable)re);
        }
    }

    SignedRequest createSignedRequest(KeyPair keyPair, String path, String authKey) throws ProfileException {
        try {
            return SignedRequestBuilder.newInstance().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(path).withHttpMethod("GET").withHeader("X-Yoti-Auth-Key", authKey).build();
        }
        catch (GeneralSecurityException ex) {
            throw new ProfileException("Cannot sign request", (Throwable)ex);
        }
        catch (UnsupportedEncodingException | URISyntaxException ex) {
            throw new ProfileException("Error creating request", (Throwable)ex);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

