/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.yoti.api.client.Image;
import com.yoti.api.client.spi.remote.call.ImageResourceFetcher;
import com.yoti.api.client.spi.remote.call.JsonResourceFetcher;
import com.yoti.api.client.spi.remote.call.RawResourceFetcher;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequestResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public class SignedRequest {
    private final URI uri;
    private final String method;
    private final byte[] data;
    private final Map<String, String> headers;
    private final JsonResourceFetcher jsonResourceFetcher;
    private final RawResourceFetcher rawResourceFetcher;
    private final ImageResourceFetcher imageResourceFetcher;

    SignedRequest(URI uri, String method, byte[] data, Map<String, String> headers, JsonResourceFetcher jsonResourceFetcher, RawResourceFetcher rawResourceFetcher, ImageResourceFetcher imageResourceFetcher) {
        this.uri = uri;
        this.method = method;
        this.data = data;
        this.headers = headers;
        this.jsonResourceFetcher = jsonResourceFetcher;
        this.rawResourceFetcher = rawResourceFetcher;
        this.imageResourceFetcher = imageResourceFetcher;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getData() {
        return this.data != null ? (byte[])this.data.clone() : null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public <T> T execute(Class<T> clazz) throws ResourceException, IOException {
        if (Image.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.imageResourceFetcher.doRequest(this));
        }
        return this.jsonResourceFetcher.doRequest(this, clazz);
    }

    public SignedRequestResponse execute() throws ResourceException, IOException {
        return this.rawResourceFetcher.doRequest(this);
    }
}

