/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call.aml;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yoti.api.client.AmlException;
import com.yoti.api.client.aml.AmlProfile;
import com.yoti.api.client.spi.remote.call.ResourceException;
import com.yoti.api.client.spi.remote.call.SignedRequest;
import com.yoti.api.client.spi.remote.call.SignedRequestBuilder;
import com.yoti.api.client.spi.remote.call.aml.SimpleAmlResult;
import com.yoti.api.client.spi.remote.call.factory.UnsignedPathFactory;
import com.yoti.api.client.spi.remote.util.Validation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;

public class RemoteAmlService {
    private final UnsignedPathFactory unsignedPathFactory;
    private final ObjectMapper objectMapper;
    private final String apiUrl;

    public static RemoteAmlService newInstance() {
        return new RemoteAmlService(new UnsignedPathFactory(), new ObjectMapper());
    }

    RemoteAmlService(UnsignedPathFactory unsignedPathFactory, ObjectMapper objectMapper) {
        this.unsignedPathFactory = unsignedPathFactory;
        this.objectMapper = objectMapper;
        this.apiUrl = System.getProperty("yoti.api.url", "https://api.yoti.com/api/v1");
    }

    public SimpleAmlResult performCheck(KeyPair keyPair, String appId, AmlProfile amlProfile) throws AmlException {
        Validation.notNull(keyPair, "Key pair");
        Validation.notNull(appId, "Application id");
        Validation.notNull(amlProfile, "amlProfile");
        try {
            String resourcePath = this.unsignedPathFactory.createAmlPath(appId);
            byte[] body = this.objectMapper.writeValueAsString((Object)amlProfile).getBytes("UTF-8");
            SignedRequest signedRequest = this.createSignedRequest(keyPair, resourcePath, body);
            return signedRequest.execute(SimpleAmlResult.class);
        }
        catch (IOException ioException) {
            throw new AmlException("Error communicating with AML endpoint", (Throwable)ioException);
        }
        catch (ResourceException resourceException) {
            throw this.createExceptionFromStatusCode(resourceException);
        }
    }

    private AmlException createExceptionFromStatusCode(ResourceException e) {
        switch (e.getResponseCode()) {
            case 400: {
                return new AmlException("Failed validation:\n" + e.getResponseBody(), (Throwable)e);
            }
            case 401: {
                return new AmlException("Failed authorization with the given key:\n" + e.getResponseBody(), (Throwable)e);
            }
            case 500: {
                return new AmlException("An unexpected error occured on the server:\n" + e.getResponseBody(), (Throwable)e);
            }
        }
        return new AmlException("Unexpected error:\n" + e.getResponseBody(), (Throwable)e);
    }

    SignedRequest createSignedRequest(KeyPair keyPair, String resourcePath, byte[] body) throws AmlException {
        try {
            return SignedRequestBuilder.newInstance().withKeyPair(keyPair).withBaseUrl(this.apiUrl).withEndpoint(resourcePath).withPayload(body).withHttpMethod("POST").build();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AmlException("Cannot sign request", (Throwable)generalSecurityException);
        }
        catch (UnsupportedEncodingException | URISyntaxException uriSyntaxException) {
            throw new AmlException("Error creating request", (Throwable)uriSyntaxException);
        }
    }
}

