/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call.factory;

import com.yoti.api.client.spi.remote.Base64;
import com.yoti.api.client.spi.remote.call.factory.MessageFactory;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;

public class SignedMessageFactory {
    private final MessageFactory messageFactory;

    public static SignedMessageFactory newInstance() {
        return new SignedMessageFactory(new MessageFactory());
    }

    public SignedMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public String create(PrivateKey privateKey, String httpMethod, String path) throws GeneralSecurityException {
        byte[] message = this.messageFactory.create(httpMethod, path, null);
        return this.signMessage(message, privateKey);
    }

    public String create(PrivateKey privateKey, String httpMethod, String path, byte[] body) throws GeneralSecurityException {
        byte[] message = this.messageFactory.create(httpMethod, path, body);
        return this.signMessage(message, privateKey);
    }

    private String signMessage(byte[] message, PrivateKey privateKey) throws GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA256withRSA", "BC");
        signature.initSign(privateKey, new SecureRandom());
        signature.update(message);
        return Base64.base64(signature.sign());
    }
}

