/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.export;

import com.youbenzi.md2.export.BuilderFactory;
import com.youbenzi.md2.export.Decorator;
import com.youbenzi.md2.markdown.Block;
import com.youbenzi.md2.markdown.MDAnalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFactory {
    public static String Encoding = "UTF-8";

    public static void produce(File file, String outputFilePath) throws FileNotFoundException, UnsupportedEncodingException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Encoding));
        FileFactory.produce(reader, outputFilePath);
    }

    public static void produce(InputStream is, String outputFilePath) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(Encoding)));
        FileFactory.produce(reader, outputFilePath);
    }

    public static void produce(String mdText, String outputFilePath) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new StringReader(mdText));
        FileFactory.produce(reader, outputFilePath);
    }

    public static void produce(BufferedReader reader, String outputFilePath) throws FileNotFoundException {
        List<Block> list = MDAnalyzer.analyze(reader);
        FileFactory.produce(list, outputFilePath);
    }

    public static void produce(List<Block> list, String outputFilePath) throws FileNotFoundException {
        String ext = FileFactory.getExtOfFile(outputFilePath);
        Decorator decorator = BuilderFactory.build(ext);
        decorator.beginWork(outputFilePath);
        decorator.decorate(list);
        decorator.afterWork(outputFilePath);
    }

    private static String getExtOfFile(String outputFilePath) {
        if (outputFilePath == null) {
            return "";
        }
        int i = outputFilePath.lastIndexOf(".");
        if (i < 0) {
            return "";
        }
        return outputFilePath.substring(i + 1);
    }

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        FileFactory.produce(new File("/Users/cevin/Downloads/\u6d4b\u8bd5.md"), "/Users/cevin/Downloads/simple.docx");
    }
}

