/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.export;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.youbenzi.md2.export.Decorator;
import com.youbenzi.md2.markdown.Block;
import com.youbenzi.md2.markdown.BlockType;
import com.youbenzi.md2.markdown.ValuePart;
import com.youbenzi.md2.util.ImgHelper;
import com.youbenzi.md2.util.MD2FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFDecorator5x
implements Decorator {
    private Document doc;
    private static BaseFont bfChinese;
    Font fontYHNormal = new Font(bfChinese, 12.0f, 0);

    public PDFDecorator5x(Document doc) {
        this.doc = doc;
    }

    @Override
    public void beginWork(String outputFilePath) {
        try {
            PdfWriter.getInstance((Document)this.doc, (OutputStream)new FileOutputStream(outputFilePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        this.doc.open();
    }

    @Override
    public void decorate(List<Block> list) {
        block10: for (Block block : list) {
            try {
                switch (block.getType()) {
                    case CODE: {
                        this.doc.add(this.codeParagraph(block.getValueParts()));
                        break;
                    }
                    case HEADLINE: {
                        this.doc.add(this.headerParagraph(block.getValueParts(), block.getLevel()));
                        break;
                    }
                    case QUOTE: {
                        List<Element> quotes = this.quoteParagraph(block.getListData());
                        for (Element element : quotes) {
                            this.doc.add(element);
                        }
                        continue block10;
                    }
                    case TABLE: {
                        this.doc.add(this.tableParagraph(block.getTableData()));
                        break;
                    }
                    case ORDERED_LIST: {
                        List<Element> els = this.listParagraph(block.getListData(), true);
                        for (Element element : els) {
                            this.doc.add(element);
                        }
                        continue block10;
                    }
                    case UNORDERED_LIST: {
                        List<Element> els = this.listParagraph(block.getListData(), false);
                        for (Element element : els) {
                            this.doc.add(element);
                        }
                        continue block10;
                    }
                    default: {
                        this.doc.add((Element)this.commonTextParagraph(block.getValueParts()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void afterWork(String outputFilePath) {
        this.doc.close();
    }

    private List<Element> listParagraph(List<Block> listData, boolean isOrder) {
        ArrayList<Element> list = new ArrayList<Element>();
        int j = 1;
        for (Block block : listData) {
            ValuePart[] vps = block.getValueParts();
            ValuePart[] newVps = new ValuePart[vps.length + 1];
            newVps[0] = isOrder ? new ValuePart(j + ". ") : new ValuePart("\u2022 ");
            for (int i = 1; i < newVps.length; ++i) {
                newVps[i] = vps[i - 1];
            }
            list.add((Element)this.commonTextParagraph(newVps));
            ++j;
        }
        return list;
    }

    private Element headerParagraph(ValuePart[] valueParts, int level) {
        Paragraph paragraph = new Paragraph();
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            Font font = new Font(bfChinese, (float)(30 - 4 * level));
            if (types != null) {
                for (BlockType type : types) {
                    this.formatByType(font, type, valuePart.getLevel());
                }
            }
            Chunk chunk = new Chunk(valuePart.getValue(), font);
            paragraph.add((Element)chunk);
        }
        paragraph.setSpacingBefore(20.0f);
        paragraph.setSpacingAfter(10.0f);
        return paragraph;
    }

    private Element tableParagraph(List<List<String>> tableData) {
        int nRows = tableData.size();
        int nCols = 0;
        for (List<String> list : tableData) {
            int s = list.size();
            if (nCols >= s) continue;
            nCols = s;
        }
        PdfPTable pdfPTable = new PdfPTable(nCols);
        pdfPTable.setWidthPercentage(100.0f);
        Font font = new Font(bfChinese, 12.0f);
        for (int i = 0; i < nRows; ++i) {
            List<String> colDatas = tableData.get(i);
            for (int j = 0; j < nCols; ++j) {
                PdfPCell cell = new PdfPCell();
                if (i == 0) {
                    cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
                }
                cell.setPaddingBottom(12.0f);
                cell.setPaddingLeft(12.0f);
                cell.setPaddingRight(12.0f);
                try {
                    cell.addElement((Element)new Chunk(colDatas.get(j), font));
                }
                catch (Exception e) {
                    cell.addElement((Element)new Chunk("", font));
                }
                pdfPTable.addCell(cell);
            }
        }
        pdfPTable.setSpacingAfter(5.0f);
        return pdfPTable;
    }

    private Element imgParagraph(ValuePart valuePart) {
        final PdfPTable pdfPTable = new PdfPTable(1);
        final PdfPCell cell = new PdfPCell();
        final String imgFile = valuePart.getValue();
        ImgHelper helper = new ImgHelper(){

            public void setIntoFile(InputStream is) {
                if (is == null) {
                    return;
                }
                try {
                    ByteArrayOutputStream baos = MD2FileUtil.inputStream2ByteArrayOutputStream(is);
                    byte[] bs = baos.toByteArray();
                    Image image = Image.getInstance((byte[])bs);
                    ByteArrayInputStream tmpIs = new ByteArrayInputStream(baos.toByteArray());
                    int[] wh = this.getImgWidthHeight(tmpIs);
                    int p = wh[0] * 100 / 1000;
                    p = p > 100 ? 100 : p;
                    pdfPTable.setWidthPercentage((float)p);
                    cell.setBorder(0);
                    cell.addElement((Element)image);
                }
                catch (Exception e) {
                    System.out.println("[error] \u65e0\u6cd5\u751f\u6210\u56fe\u7247\uff1a" + imgFile + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        };
        InputStream result = helper.setImgByUrl(imgFile);
        if (result == null) {
            ValuePart part = new ValuePart("\u56fe\u7247\u5730\u5740\uff1a" + imgFile);
            return this.commonTextParagraph(new ValuePart[]{part});
        }
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.addCell(cell);
        pdfPTable.setSpacingAfter(5.0f);
        return pdfPTable;
    }

    private Element codeParagraph(ValuePart[] valueParts) throws DocumentException {
        String value = valueParts[0].getValue();
        Paragraph p = new Paragraph(value, new Font(bfChinese, 12.0f));
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.setWidthPercentage(100.0f);
        PdfPCell cell = new PdfPCell();
        cell.addElement((Element)p);
        cell.setBorder(15);
        cell.setPaddingBottom(12.0f);
        cell.setPaddingLeft(12.0f);
        cell.setPaddingRight(12.0f);
        cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
        pdfPTable.addCell(cell);
        pdfPTable.setSpacingAfter(5.0f);
        return pdfPTable;
    }

    private List<Element> quoteParagraph(List<Block> listData) {
        boolean isFirst = true;
        ArrayList<Element> results = new ArrayList<Element>();
        for (int i = 0; i < listData.size(); ++i) {
            Block block = listData.get(i);
            if (i > 0) {
                isFirst = false;
            }
            Element element = this.quoteParagraph(block.getValueParts(), isFirst);
            results.add(element);
        }
        return results;
    }

    private Element quoteParagraph(ValuePart[] valueParts, boolean isFirst) {
        Paragraph p = new Paragraph();
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            Font font = new Font(bfChinese);
            if (types != null) {
                for (BlockType type : types) {
                    this.formatByType(font, type, valuePart.getLevel());
                }
            }
            Chunk chunk = new Chunk(valuePart.getValue(), font);
            p.add((Element)chunk);
        }
        PdfPTable pdfPTable = new PdfPTable(2);
        try {
            PdfPCell cell;
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.setWidths(new int[]{1, 20});
            try {
                cell = new PdfPCell();
                if (isFirst) {
                    InputStream is = PDFDecorator5x.class.getResourceAsStream("/quote_char.jpg");
                    Image image = Image.getInstance((byte[])MD2FileUtil.inputStream2ByteArrayOutputStream(is).toByteArray());
                    cell.addElement((Element)image);
                } else {
                    cell.addElement((Element)new Chunk());
                }
                cell.setBorder(0);
                pdfPTable.addCell(cell);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cell = new PdfPCell();
            cell.addElement((Element)p);
            cell.setBorder(0);
            if (isFirst) {
                cell.setPaddingTop(10.0f);
            }
            cell.setPaddingBottom(5.0f);
            pdfPTable.addCell(cell);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pdfPTable;
    }

    private Paragraph commonTextParagraph(ValuePart[] valueParts) {
        Paragraph p = new Paragraph();
        if (valueParts == null) {
            return p;
        }
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            Font font = new Font(bfChinese);
            boolean hasImg = false;
            if (types != null) {
                for (BlockType type : types) {
                    if (type == BlockType.IMG) {
                        hasImg = true;
                        break;
                    }
                    this.formatByType(font, type, valuePart.getLevel());
                }
            }
            if (hasImg) {
                p.add(this.imgParagraph(valuePart));
                continue;
            }
            Chunk chunk = new Chunk(valuePart.getValue(), font);
            p.add((Element)chunk);
        }
        p.setSpacingAfter(5.0f);
        return p;
    }

    private void formatByType(Font font, BlockType type, int level) {
        switch (type) {
            case BOLD_WORD: {
                font.setStyle(1);
                break;
            }
            case ITALIC_WORD: {
                font.setStyle(2);
                break;
            }
            case STRIKE_WORD: {
                font.setStyle(8);
                break;
            }
            case CODE_WORD: {
                font.setColor(BaseColor.RED);
                break;
            }
            case HEADLINE: {
                font.setSize(16.0f);
                font.setStyle(1);
                break;
            }
        }
    }

    static {
        try {
            bfChinese = BaseFont.createFont((String)"MSYH.TTF", (String)"Identity-H", (boolean)false);
        }
        catch (Exception e1) {
            try {
                bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("\u6ca1\u6709\u627e\u5230MSYH.TTF\u5b57\u4f53\u6587\u4ef6\uff0c\u4f7f\u7528itext\u81ea\u5e26\u4e2d\u6587\u5b57\u4f53\u3002\u5982\u679c\u9700\u8981\u66f4\u597d\u7684\u663e\u793a\u6548\u679c\uff0c\u53ef\u4ee5\u6dfb\u52a0MSYH.TTF\u5230src\u76ee\u5f55\u4e0b");
        }
    }
}

