/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.markdown;

import com.youbenzi.md2.markdown.BlockType;
import com.youbenzi.md2.markdown.MDToken;
import java.util.Arrays;
import java.util.Map;

public class ValuePart {
    private String value;
    private BlockType[] types;
    private int level;
    private String url;
    private String title;

    public ValuePart() {
    }

    public ValuePart(String value) {
        this.value = this.revertValue(value);
    }

    public ValuePart(String value, BlockType ... types) {
        this.value = this.revertValue(value);
        this.types = types;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = this.revertValue(value);
    }

    public BlockType[] getTypes() {
        return this.types;
    }

    public void setTypes(BlockType ... types) {
        this.types = types;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addType(BlockType type) {
        this.types = this.types != null ? Arrays.copyOf(this.types, this.types.length + 1) : new BlockType[1];
        this.types[this.types.length - 1] = type;
    }

    public String revertValue(String value) {
        for (Map.Entry<String, String> entry : MDToken.PLACEHOLDER_MAP.entrySet()) {
            String tmpValue = entry.getKey().substring(1);
            value = value.replace(entry.getValue(), tmpValue);
        }
        return value;
    }

    public String toString() {
        return "value:" + this.value + "|types:" + Arrays.toString((Object[])this.types);
    }

    public static void main(String[] args) {
        ValuePart part = new ValuePart();
        part.setTypes(BlockType.BOLD_WORD, BlockType.CODE);
        System.out.println(Arrays.toString((Object[])part.types));
        part.addType(BlockType.HEADLINE);
        System.out.println(Arrays.toString((Object[])part.types));
    }
}

