/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.export;

import com.youbenzi.mdtool.export.Decorator;
import com.youbenzi.mdtool.markdown.BlockType;
import com.youbenzi.mdtool.markdown.TableCellAlign;
import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.bean.ValuePart;
import com.youbenzi.mdtool.tool.MDTool;
import com.youbenzi.mdtool.tool.Tools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class HTMLDecorator
implements Decorator {
    private StringBuilder content = new StringBuilder();

    @Override
    public void beginWork(String outputFilePath) {
    }

    @Override
    public void decorate(List<Block> list) {
        for (Block block : list) {
            try {
                String str;
                switch (block.getType()) {
                    case CODE: {
                        str = this.codeParagraph(block.getValueParts());
                        break;
                    }
                    case HEADLINE: {
                        str = this.headerParagraph(block.getValueParts(), block.getLevel());
                        break;
                    }
                    case QUOTE: {
                        str = this.quoteParagraph(block.getListData());
                        break;
                    }
                    case TABLE: {
                        str = this.tableParagraph(block.getTableData());
                        break;
                    }
                    case LIST: {
                        str = this.listParagraph(block.getListData());
                        break;
                    }
                    default: {
                        str = this.commonTextParagraph(block.getValueParts(), true);
                    }
                }
                this.content.append(str).append("\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterWork(String outputFilePath) {
        File file = new File(outputFilePath);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(this.content.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String outputHtml() {
        return this.content.toString();
    }

    private String codeParagraph(ValuePart[] valueParts) {
        String value = valueParts[0].getValue();
        StringBuilder tmp = new StringBuilder("<pre>");
        tmp.append("<code>");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        if (value.endsWith("\n")) {
            value = value.substring(0, value.length() - "\n".length());
        }
        tmp.append(value);
        tmp.append("</code>");
        tmp.append("</pre>\n");
        return tmp.toString();
    }

    private String headerParagraph(ValuePart[] valueParts, int level) {
        return this.oneLineHtml(valueParts, "h" + level);
    }

    private String listParagraph(List<Block> listData) {
        StringBuilder tmp = new StringBuilder();
        for (Block block : listData) {
            tmp.append(this.listParagraph(block.getType(), block.getListData()));
        }
        return tmp.toString();
    }

    private String listParagraph(BlockType blockType, List<Block> listData) {
        StringBuilder tmp = new StringBuilder();
        switch (blockType) {
            case ORDERED_LIST: {
                tmp.append(this.orderedListParagraph(listData)).append("\n");
                break;
            }
            case UNORDERED_LIST: {
                tmp.append(this.unorderedListParagraph(listData)).append("\n");
                break;
            }
            case QUOTE: {
                tmp.append(this.quoteParagraph(listData)).append("\n");
                break;
            }
            case TODO_LIST: {
                tmp.append(this.todoListParagraph(listData)).append("\n");
                break;
            }
        }
        return tmp.toString();
    }

    private String formatByType(BlockType type, String value, ValuePart valuePart) {
        switch (type) {
            case BOLD_WORD: {
                return "<strong>" + value + "</strong>";
            }
            case ITALIC_WORD: {
                return "<em>" + value + "</em>";
            }
            case STRIKE_WORD: {
                return "<del>" + value + "</del>";
            }
            case CODE_WORD: {
                return "<code>" + value + "</code>";
            }
            case HEADLINE: {
                int level = valuePart.getLevel() + 1;
                return "<h" + level + ">" + value + "</h" + level + ">";
            }
            case LINK: {
                return "<a href=\"" + valuePart.getUrl() + "\" title=\"" + Tools.filterHtml(value) + "\">" + value + "</a>";
            }
            case IMG: {
                return "<img src=\"" + valuePart.getUrl() + "\" title=\"" + valuePart.getTitle() + "\" alt=\"" + valuePart.getTitle() + "\" />";
            }
            case ROW: {
                return "<br/>";
            }
        }
        return value;
    }

    private String tableParagraph(List<List<Block>> tableData) {
        int nRows = tableData.size();
        int nCols = 0;
        for (List<Block> list : tableData) {
            int s = list.size();
            if (nCols >= s) continue;
            nCols = s;
        }
        StringBuilder tmp = new StringBuilder("<table>\n");
        for (int i = 0; i < nRows; ++i) {
            tmp.append("<tr>\n");
            List<Block> colDatas = tableData.get(i);
            for (int j = 0; j < nCols; ++j) {
                Block block = colDatas.get(j);
                boolean head = i == 0;
                tmp.append(this.buildColBegin(head, block.getAlign()));
                try {
                    tmp.append(this.commonTextParagraph(colDatas.get(j).getValueParts(), false));
                }
                catch (Exception e) {
                    tmp.append("");
                }
                tmp.append("</" + (head ? "th" : "td") + ">\n");
            }
            tmp.append("</tr>\n");
        }
        tmp.append("</table>\n");
        return tmp.toString();
    }

    private String buildColBegin(boolean head, TableCellAlign align) {
        String alignString = "";
        if (align != TableCellAlign.NONE) {
            alignString = "align=\"" + align.value() + "\"";
        }
        return "<" + (head ? "th" : "td") + " " + alignString + ">";
    }

    private String abstractListParagraph(List<Block> listData, LineHelper lineHelper) {
        StringBuilder tmp = new StringBuilder(lineHelper.parentTagBegin() + "\n");
        for (Block block : listData) {
            Block lineBlock = block.getLineData();
            String content = lineBlock.getType() == BlockType.HEADLINE ? this.headerParagraph(lineBlock.getValueParts(), lineBlock.getLevel()) : this.commonTextParagraph(lineBlock.getValueParts(), lineHelper.needDefaultChild());
            tmp.append(lineHelper.childTagBegin(block));
            tmp.append(content).append("\n").append(lineHelper.subList(block));
            tmp.append(lineHelper.childTagEnd());
        }
        tmp.append(lineHelper.parentTagEnd() + "\n");
        return tmp.toString();
    }

    private String quoteParagraph(List<Block> listData) {
        return this.abstractListParagraph(listData, new DefaultLineHelper("blockquote"));
    }

    private String unorderedListParagraph(List<Block> listData) {
        return this.abstractListParagraph(listData, new DefaultLineHelper("ul", "li"));
    }

    private String orderedListParagraph(List<Block> listData) {
        return this.abstractListParagraph(listData, new DefaultLineHelper("ol", "li"));
    }

    private String todoListParagraph(List<Block> listData) {
        return this.abstractListParagraph(listData, new DefaultLineHelper("ul", "li"){

            @Override
            public String decorate(Block block, String tag) {
                if (block.getMdToken().equals("[ ]")) {
                    return "<" + tag + "><i class=\"unchecked_icon\"></i>";
                }
                return "<" + tag + "><i class=\"checked_icon\"></i>";
            }
        });
    }

    private String commonTextParagraph(ValuePart[] valueParts, boolean needPTag) {
        return this.oneLineHtml(valueParts, needPTag ? "p" : null);
    }

    private String oneLineHtml(ValuePart[] valueParts, String tagName) {
        StringBuilder result = new StringBuilder();
        if (tagName != null && !tagName.trim().equals("")) {
            result.append("<" + tagName + ">");
        }
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            String value = valuePart.getValue();
            if (this.hasLink(types)) {
                value = valuePart.getTitle();
            }
            if (types != null) {
                for (BlockType type : types) {
                    value = this.formatByType(type, value, valuePart);
                }
            }
            result.append(value);
        }
        if (tagName != null && !tagName.trim().equals("")) {
            result.append("</" + tagName + ">");
        }
        return result.toString();
    }

    private boolean hasLink(BlockType[] types) {
        if (types == null) {
            return false;
        }
        for (BlockType blockType : types) {
            if (blockType != BlockType.LINK) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String content = "1. \u5217\u88681.1\n2. \u5217\u88681.2\n    * \u5217\u88682.1\n    * \u5217\u88682.2\n    * \u5217\u88682.3\n    * \u5217\u88682.4\n";
        System.out.println(MDTool.markdown2Html(content));
    }

    public class DefaultLineHelper
    extends LineHelper {
        private String parentTag;
        private String childTag;

        public DefaultLineHelper(String parentTag, String childTag) {
            this.parentTag = parentTag;
            this.childTag = childTag;
        }

        public DefaultLineHelper(String parentTag) {
            this.parentTag = parentTag;
            this.childTag = null;
        }

        @Override
        public boolean needDefaultChild() {
            return this.childTag == null;
        }

        @Override
        public String parentTagBegin() {
            return "<" + this.parentTag + ">";
        }

        @Override
        public String parentTagEnd() {
            return "</" + this.parentTag + ">";
        }

        @Override
        public String childTagBegin(Block block) {
            return this.decorate(block, this.childTag);
        }

        @Override
        public String childTagEnd() {
            if (this.childTag == null) {
                return "";
            }
            return "</" + this.childTag + ">";
        }

        @Override
        public String subList(Block block) {
            if (block.getType() != null) {
                return HTMLDecorator.this.listParagraph(block.getType(), block.getListData());
            }
            return "";
        }
    }

    public abstract class LineHelper {
        public abstract String subList(Block var1);

        public abstract String parentTagBegin();

        public abstract String parentTagEnd();

        public abstract String childTagBegin(Block var1);

        public abstract String childTagEnd();

        public abstract boolean needDefaultChild();

        public String decorate(Block block, String tag) {
            if (tag == null) {
                return "";
            }
            return "<" + tag + ">";
        }
    }
}

