/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown;

import com.youbenzi.mdtool.markdown.BlockType;
import com.youbenzi.mdtool.markdown.MDToken;
import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.bean.TextLinePiece;
import com.youbenzi.mdtool.markdown.bean.ValuePart;
import com.youbenzi.mdtool.markdown.filter.CodePartFilter;
import com.youbenzi.mdtool.markdown.filter.HeaderNextLineFilter;
import com.youbenzi.mdtool.markdown.filter.HeaderOneLineFilter;
import com.youbenzi.mdtool.markdown.filter.ListFilter;
import com.youbenzi.mdtool.markdown.filter.TablePartFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Analyzer {
    private static List<String> mdTokenInLine = Arrays.asList("**", "__", "_", "*", "~~", "`", "![", "[");

    public static List<Block> analyze(String content) {
        content = Analyzer.formatText(content);
        CodePartFilter filter = new CodePartFilter(new TablePartFilter(new HeaderOneLineFilter(new ListFilter(new HeaderNextLineFilter(null)))));
        List<Block> blocks = filter.call(content);
        return blocks;
    }

    public static List<ValuePart> analyzeLineText(String text) {
        List<ValuePart> result = Analyzer.text2ValuePart(text.trim(), new ArrayList<String>(), new ArrayList<String>());
        if (text.endsWith("  ")) {
            result.add(Analyzer.createValuePart("", Arrays.asList("  ")));
        }
        return result;
    }

    private static List<ValuePart> text2ValuePart(String text, List<String> notCheckMDTokens, List<String> currentTypes) {
        int textLength;
        ArrayList<ValuePart> result = new ArrayList<ValuePart>();
        text = ValuePart.convertValue(text);
        int i = textLength = text.length();
        String mdToken = null;
        for (String tmp : mdTokenInLine) {
            int j;
            if (notCheckMDTokens.contains(tmp) || (j = text.indexOf(tmp)) <= -1 || i <= j) continue;
            i = j;
            mdToken = tmp;
        }
        TextLinePiece piece = Analyzer.checkIfCorrectSyntax(i, mdToken, text);
        int firstPartEndIndex = textLength;
        int secondPartEndIndex = 0;
        int thirdPartEndIndex = 0;
        if (piece != null) {
            firstPartEndIndex = piece.getBeginIndex();
            secondPartEndIndex = piece.getEndIndex();
            if (secondPartEndIndex < textLength - 1) {
                thirdPartEndIndex = textLength;
            }
        }
        if (firstPartEndIndex > 0) {
            ValuePart valuePart = Analyzer.createValuePart(text.substring(0, firstPartEndIndex), currentTypes);
            result.add(valuePart);
        }
        if (secondPartEndIndex > 0) {
            List<String> currentTypesClone = Analyzer.cloneList(currentTypes);
            List<String> notCheckMDTokensClone = Analyzer.cloneList(notCheckMDTokens);
            notCheckMDTokensClone.add(mdToken);
            currentTypesClone.add(mdToken);
            ValuePart valuePart = null;
            switch (piece.getPieceType()) {
                case LINK: {
                    valuePart = Analyzer.analyzeTextInLink(piece.getTitle(), notCheckMDTokensClone, currentTypesClone);
                    String tmpValue = valuePart.getTitle() + "(" + piece.getUrl() + ")";
                    valuePart.setValue(tmpValue);
                    valuePart.setUrl(piece.getUrl());
                    result.add(valuePart);
                    break;
                }
                case IMAGE: {
                    valuePart = Analyzer.createValuePart(piece.getUrl(), currentTypesClone);
                    valuePart.setTitle(piece.getTitle());
                    valuePart.setUrl(piece.getUrl());
                    result.add(valuePart);
                    break;
                }
                default: {
                    String sencondPart = text.substring(piece.getBeginIndex() + mdToken.length(), secondPartEndIndex);
                    if (mdToken.equals("`")) {
                        notCheckMDTokensClone = mdTokenInLine;
                    }
                    List<ValuePart> tmpList2 = Analyzer.text2ValuePart(sencondPart, notCheckMDTokensClone, currentTypesClone);
                    for (ValuePart tmp : tmpList2) {
                        result.add(tmp);
                    }
                }
            }
        }
        if (thirdPartEndIndex > 0) {
            String thirdPart = "";
            thirdPart = piece.getPieceType() == TextLinePiece.PieceType.IMAGE ? text.substring(piece.getEndIndex() + 1) : text.substring(piece.getEndIndex() + mdToken.length());
            List<ValuePart> tmpList1 = Analyzer.text2ValuePart(thirdPart, notCheckMDTokens, currentTypes);
            for (ValuePart valuePart : tmpList1) {
                result.add(valuePart);
            }
        }
        return result;
    }

    private static List<String> cloneList(List<String> target) {
        ArrayList<String> result = new ArrayList<String>();
        for (String tmp : target) {
            result.add(tmp);
        }
        return result;
    }

    private static TextLinePiece checkIfCorrectSyntax(int i, String mdToken, String text) {
        if (mdToken == null) {
            return null;
        }
        TextLinePiece textLinePiece = null;
        if (mdToken.equals("[") || mdToken.equals("![")) {
            textLinePiece = Analyzer.hasLinkOrImage(text, mdToken.equals("["));
        } else {
            int j = text.indexOf(mdToken, i + mdToken.length());
            if (j > -1) {
                textLinePiece = new TextLinePiece(i, j, TextLinePiece.PieceType.COMMON);
            }
        }
        return textLinePiece;
    }

    private static ValuePart createValuePart(String value, List<String> mdTokens) {
        ValuePart valuePart = new ValuePart();
        valuePart.setValue(value);
        if (mdTokens.size() > 0) {
            BlockType[] types = new BlockType[mdTokens.size()];
            int i = 0;
            for (int k = mdTokens.size() - 1; k >= 0; --k) {
                types[i] = MDToken.convert(mdTokens.get(k));
                ++i;
            }
            valuePart.setTypes(types);
        }
        return valuePart;
    }

    private static TextLinePiece hasLinkOrImage(String str, boolean isLink) {
        int l;
        int k;
        TextLinePiece linkOrImageBean = new TextLinePiece();
        linkOrImageBean.setPieceType(isLink ? TextLinePiece.PieceType.LINK : TextLinePiece.PieceType.IMAGE);
        String token = null;
        token = isLink ? "[" : "![";
        int i = str.indexOf(token);
        int j = str.indexOf("]", i);
        if (j > 0 && (k = str.indexOf("(", j)) > 0 && k == j + 1 && (l = str.indexOf(")", k)) > 0) {
            String strHasUrl = str.substring(k + 1, l).trim();
            int m = strHasUrl.indexOf(" ");
            String url = "";
            url = m > -1 ? strHasUrl.substring(0, m) : strHasUrl;
            String title = str.substring(i + token.length(), j);
            linkOrImageBean.setBeginIndex(i);
            linkOrImageBean.setEndIndex(l);
            linkOrImageBean.setTitle(title);
            linkOrImageBean.setUrl(url);
            return linkOrImageBean;
        }
        return null;
    }

    private static ValuePart analyzeTextInLink(String str, List<String> notCheckMDTokens, List<String> currentTypes) {
        String mdToken = null;
        for (String tmp : mdTokenInLine) {
            int end;
            if (notCheckMDTokens.contains(tmp) || !str.startsWith(tmp) || (end = str.indexOf(tmp, tmp.length())) <= 0) continue;
            mdToken = tmp;
            break;
        }
        if (mdToken != null) {
            notCheckMDTokens.add(mdToken);
            currentTypes.add(mdToken);
            str = str.substring(mdToken.length(), str.length() - mdToken.length());
            return Analyzer.analyzeTextInLink(str, notCheckMDTokens, currentTypes);
        }
        ValuePart valuePart = Analyzer.createValuePart("", currentTypes);
        valuePart.setTitle(str);
        return valuePart;
    }

    private static String formatText(String text) {
        text = text.replaceAll("\t", "    ");
        return text;
    }
}

