/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown;

import com.youbenzi.mdtool.markdown.BlockType;
import java.util.LinkedHashMap;
import java.util.Map;

public class MDToken {
    public static final String QUOTE = ">";
    public static final String CODE = "```";
    public static final String CODE_BLANK = "    ";
    public static final String HEADLINE = "#";
    public static final String IMG = "![";
    public static final String LINK = "[";
    public static final String UNORDERED_LIST1 = "* ";
    public static final String UNORDERED_LIST2 = "- ";
    public static final String UNORDERED_LIST3 = "+ ";
    public static final String TODO_LIST_UNCHECKED = "[ ]";
    public static final String TODO_LIST_CHECKED = "[x]";
    public static final String BOLD_WORD1 = "**";
    public static final String BOLD_WORD2 = "__";
    public static final String ITALIC_WORD = "_";
    public static final String ITALIC_WORD_2 = "*";
    public static final String STRIKE_WORD = "~~";
    public static final String CODE_WORD = "`";
    public static final String ROW = "  ";
    public static final Map<String, String> PLACEHOLDER_MAP = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 5649442662460683378L;
        {
            this.put("\\\\", "$BACKSLASH");
            this.put("\\![", "$IMG");
            this.put("\\[", "$LINK");
            this.put("\\_", "$ITALICWORD");
            this.put("\\*", "$2ITALICWORD");
            this.put("\\~~", "$STRIKEWORD");
            this.put("\\`", "$CODEWORD");
            this.put("\\", "");
        }
    };

    public static BlockType convert(String mdToken) {
        if (mdToken.equals(QUOTE)) {
            return BlockType.QUOTE;
        }
        if (mdToken.equals(CODE)) {
            return BlockType.CODE;
        }
        if (mdToken.equals(HEADLINE)) {
            return BlockType.HEADLINE;
        }
        if (mdToken.equals(IMG)) {
            return BlockType.IMG;
        }
        if (mdToken.equals(BOLD_WORD1) || mdToken.equals(BOLD_WORD2)) {
            return BlockType.BOLD_WORD;
        }
        if (mdToken.equals(ITALIC_WORD) || mdToken.equals(ITALIC_WORD_2)) {
            return BlockType.ITALIC_WORD;
        }
        if (mdToken.equals(STRIKE_WORD)) {
            return BlockType.STRIKE_WORD;
        }
        if (mdToken.equals(CODE_WORD)) {
            return BlockType.CODE_WORD;
        }
        if (mdToken.equals(LINK)) {
            return BlockType.LINK;
        }
        if (mdToken.equals(ROW)) {
            return BlockType.ROW;
        }
        return BlockType.NONE;
    }
}

