/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.builder;

import com.youbenzi.mdtool.markdown.BlockType;
import com.youbenzi.mdtool.markdown.TableCellAlign;
import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.builder.BlockBuilder;
import com.youbenzi.mdtool.markdown.builder.CommonTextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableBuilder
implements BlockBuilder {
    private List<List<String>> data;
    private Map<Integer, TableCellAlign> cellAligns;

    public TableBuilder(List<List<String>> data, Map<Integer, TableCellAlign> cellAligns) {
        this.data = data;
        this.cellAligns = cellAligns;
    }

    @Override
    public Block bulid() {
        Block block = new Block();
        block.setType(BlockType.TABLE);
        block.setTableData(this.convertData(this.data, this.cellAligns));
        return block;
    }

    private List<List<Block>> convertData(List<List<String>> data, Map<Integer, TableCellAlign> cellAligns) {
        ArrayList<List<Block>> result = new ArrayList<List<Block>>();
        for (List<String> list : data) {
            ArrayList<Block> blocks = new ArrayList<Block>();
            int s = list.size();
            for (int i = 0; i < s; ++i) {
                String str = list.get(i);
                Block block = new CommonTextBuilder(str).bulid();
                TableCellAlign align = cellAligns.get(i);
                block.setAlign(align == null ? TableCellAlign.NONE : align);
                blocks.add(block);
            }
            result.add(blocks);
        }
        return result;
    }

    @Override
    public boolean isRightType() {
        return false;
    }
}

