/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.filter;

import com.youbenzi.mdtool.markdown.bean.TextOrBlock;
import com.youbenzi.mdtool.markdown.builder.CodeBuilder;
import com.youbenzi.mdtool.markdown.filter.SyntaxFilter;
import java.util.ArrayList;
import java.util.List;

public class CodePartFilter
extends SyntaxFilter {
    private static final int CODE_PART_TYPE_NONE = 0;
    private static final int CODE_PART_TYPE_BLANK = 1;
    private static final int CODE_PART_TYPE_TOKEN = 2;

    public CodePartFilter(SyntaxFilter nextFilter) {
        super(nextFilter);
    }

    @Override
    public List<TextOrBlock> invoke(List<String> lines) {
        ArrayList<TextOrBlock> textOrBlocks = new ArrayList<TextOrBlock>();
        StringBuilder outerText = new StringBuilder();
        int si = lines.size();
        for (int idx = 0; idx < si; ++idx) {
            String previousLine = this.getFromList(lines, idx - 1);
            String currentLine = this.getFromList(lines, idx);
            int codePartType = this.isCodePartBegin(currentLine, previousLine);
            if (codePartType != 0) {
                StringBuilder interText = this.initCodePartText(currentLine, codePartType);
                boolean isCodeEnd = false;
                for (int idx1 = idx + 1; idx1 < si; ++idx1) {
                    String nextLine;
                    currentLine = this.getFromList(lines, idx1);
                    if (this.isCodePartEnd(currentLine, nextLine = this.getFromList(lines, idx1 + 1), codePartType, interText)) {
                        isCodeEnd = true;
                        idx = idx1;
                        break;
                    }
                    interText.append(currentLine + "\n");
                }
                if (isCodeEnd) {
                    if (!outerText.toString().equals("")) {
                        textOrBlocks.add(new TextOrBlock(outerText.toString()));
                        outerText = new StringBuilder();
                    }
                    textOrBlocks.add(new TextOrBlock(new CodeBuilder(interText.toString()).bulid()));
                    continue;
                }
                String content = outerText.append("```").append("\n").append(interText.toString()).toString();
                textOrBlocks.add(new TextOrBlock(content));
                outerText = new StringBuilder();
                break;
            }
            outerText.append(currentLine + "\n");
        }
        if (!outerText.toString().equals("")) {
            textOrBlocks.add(new TextOrBlock(outerText.toString()));
        }
        return textOrBlocks;
    }

    private StringBuilder initCodePartText(String currentLine, int codePartType) {
        StringBuilder text = new StringBuilder();
        if (codePartType == 1) {
            text.append(currentLine).append("\n");
        }
        return text;
    }

    private int isCodePartBegin(String currentLine, String previousLine) {
        if (currentLine.trim().startsWith("```")) {
            return 2;
        }
        if (previousLine == null || previousLine.trim().equals("")) {
            return this.isCode(currentLine, 1) ? 1 : 0;
        }
        return 0;
    }

    private boolean isCodePartEnd(String currentLine, String nextLine, int codePartType, StringBuilder currentText) {
        switch (codePartType) {
            case 2: {
                if (!currentLine.trim().startsWith("```")) break;
                return true;
            }
            case 1: {
                if (nextLine == null) {
                    if (!currentLine.trim().equals("")) {
                        currentText.append(currentLine).append("\n");
                    }
                    return true;
                }
                if (nextLine.trim().equals("") || !currentLine.trim().equals("")) break;
                return true;
            }
        }
        return false;
    }

    private boolean isCode(String currentLine, int codePartType) {
        switch (codePartType) {
            case 2: {
                return true;
            }
        }
        return currentLine.startsWith("    ");
    }

    private String getFromList(List<String> list, int index) {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

