/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.filter;

import com.youbenzi.mdtool.markdown.bean.TextOrBlock;
import com.youbenzi.mdtool.markdown.builder.HeaderBuilder;
import com.youbenzi.mdtool.markdown.filter.SyntaxFilter;
import java.util.ArrayList;
import java.util.List;

public class HeaderOneLineFilter
extends SyntaxFilter {
    public HeaderOneLineFilter(SyntaxFilter nextFilter) {
        super(nextFilter);
    }

    @Override
    public List<TextOrBlock> invoke(List<String> lines) {
        ArrayList<TextOrBlock> textOrBlocks = new ArrayList<TextOrBlock>();
        StringBuilder outerText = new StringBuilder();
        int si = lines.size();
        for (int idx = 0; idx < si; ++idx) {
            String str = lines.get(idx);
            if (str.trim().startsWith("#")) {
                if (!outerText.toString().equals("")) {
                    textOrBlocks.add(new TextOrBlock(outerText.toString()));
                    outerText = new StringBuilder();
                }
                textOrBlocks.add(new TextOrBlock(new HeaderBuilder(str).bulid()));
                continue;
            }
            outerText.append(str).append("\n");
        }
        if (!outerText.toString().equals("")) {
            textOrBlocks.add(new TextOrBlock(outerText.toString()));
        }
        return textOrBlocks;
    }
}

