/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.filter;

import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.bean.TextOrBlock;
import com.youbenzi.mdtool.markdown.builder.CommonTextBuilder;
import com.youbenzi.mdtool.tool.Tools;
import java.util.ArrayList;
import java.util.List;

public abstract class SyntaxFilter {
    private SyntaxFilter nextFilter = null;

    public abstract List<TextOrBlock> invoke(List<String> var1);

    public SyntaxFilter(SyntaxFilter nextFilter) {
        this.nextFilter = nextFilter;
    }

    public List<Block> call(String content) {
        List<TextOrBlock> textOrBlocks = this.invoke(Tools.read2List(content));
        ArrayList<Block> result = new ArrayList<Block>();
        for (TextOrBlock textOrBlock : textOrBlocks) {
            if (textOrBlock.isBlock()) {
                result.add(textOrBlock.getBlock());
                continue;
            }
            String text = textOrBlock.getText();
            if (this.nextFilter != null) {
                result.addAll(this.nextFilter.call(text));
                continue;
            }
            result.addAll(this.buildCommonTextBlock(text));
        }
        return result;
    }

    private List<Block> buildCommonTextBlock(String text) {
        ArrayList<Block> result = new ArrayList<Block>();
        List<String> lines = Tools.read2List(text);
        StringBuilder commonText = new StringBuilder();
        int l = lines.size();
        for (int idx = 0; idx < l; ++idx) {
            String line = lines.get(idx);
            if (idx + 1 < l) {
                String nextLine = lines.get(idx + 1);
                commonText.append(line + "\n");
                if (!nextLine.trim().equals("") || commonText.toString().equals("")) continue;
                result.add(new CommonTextBuilder(commonText.toString()).bulid());
                commonText = new StringBuilder();
                ++idx;
                continue;
            }
            commonText.append(line + "\n");
        }
        if (!commonText.toString().equals("")) {
            result.add(new CommonTextBuilder(commonText.toString()).bulid());
        }
        return result;
    }
}

