/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.builder;

import com.youbenzi.mdtool.markdown.Analyzer;
import com.youbenzi.mdtool.markdown.BlockType;
import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.bean.ValuePart;
import com.youbenzi.mdtool.markdown.builder.BlockBuilder;
import java.util.List;

public class HeaderBuilder
implements BlockBuilder {
    private String content;

    public HeaderBuilder(String content) {
        this.content = content;
    }

    @Override
    public Block bulid() {
        this.content = this.content.trim();
        int i = this.content.lastIndexOf("#");
        this.content = this.content.substring(i + 1).trim();
        return this.bulid(i);
    }

    public Block bulid(int level) {
        Block block = new Block();
        List<ValuePart> list = Analyzer.analyzeLineText(this.content);
        block.setType(BlockType.HEADLINE);
        block.setValueParts(list);
        block.setLevel(level + 1);
        return block;
    }

    @Override
    public boolean isRightType() {
        return this.content.startsWith("#");
    }

    public static int isRightType(String nextLineStr) {
        if (!nextLineStr.startsWith("-") && !nextLineStr.startsWith("=")) {
            return 0;
        }
        String tmpS = nextLineStr.replaceAll("-", "").trim();
        if (tmpS.length() == 0) {
            return 2;
        }
        tmpS = nextLineStr.replaceAll("=", "").trim();
        if (tmpS.length() == 0) {
            return 1;
        }
        return 0;
    }
}

