/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.builder;

import com.youbenzi.mdtool.markdown.BlockType;
import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.builder.BlockBuilder;
import com.youbenzi.mdtool.markdown.builder.CommonTextBuilder;
import com.youbenzi.mdtool.markdown.builder.HeaderBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class MultiListBuilder
implements BlockBuilder {
    private String content;

    public MultiListBuilder(String content) {
        this.content = content;
    }

    private String blankStrInHead(String line) {
        if (line == null) {
            return "";
        }
        String blankStr = " ";
        while (line.startsWith(blankStr)) {
            blankStr = blankStr + " ";
        }
        return blankStr.substring(1, blankStr.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block bulid() {
        BufferedReader br = new BufferedReader(new StringReader(this.content));
        Block block = new Block();
        ArrayList<Block> listData = new ArrayList<Block>();
        block.setType(BlockType.LIST);
        block.setListData(listData);
        try {
            String value = br.readLine();
            while (value != null) {
                Block subBlock = new Block();
                value = this.buildListBlock(subBlock, value, br, new ArrayList<TypeAndBlank>());
                listData.add(subBlock);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return block;
    }

    private boolean jumpOut(List<TypeAndBlank> levels, TypeAndBlank currentLevels) {
        ArrayList<TypeAndBlank> childLevels = new ArrayList<TypeAndBlank>();
        for (TypeAndBlank typeAndBlank : levels) {
            if (typeAndBlank.getBlankStr().equals(currentLevels.getBlankStr()) && typeAndBlank.getBlockType() == currentLevels.getBlockType()) {
                Iterator<TypeAndBlank> it = levels.iterator();
                int l = childLevels.size();
                for (int i = 0; i < l; ++i) {
                    it.next();
                    it.remove();
                }
                return true;
            }
            childLevels.add(typeAndBlank);
        }
        return false;
    }

    private String buildListBlock(Block result, String value, BufferedReader br, List<TypeAndBlank> levels) throws IOException {
        String firstBlankStr = this.blankStrInHead(value);
        BlockType firstCurrentType = MultiListBuilder.listType(value);
        ArrayList<Block> listData = new ArrayList<Block>();
        result.setType(firstCurrentType);
        result.setListData(listData);
        levels.add(0, new TypeAndBlank(firstBlankStr, firstCurrentType));
        while (value != null) {
            BlockType blockType = MultiListBuilder.listType(value);
            String blankStr = this.blankStrInHead(value);
            if (!blankStr.equals(firstBlankStr) || blockType != firstCurrentType) {
                return value;
            }
            Block block = new Block();
            int index = MultiListBuilder.computeCharIndex(value = value.substring(firstBlankStr.length()), blockType);
            if (index < 0) {
                value = br.readLine();
                continue;
            }
            block.setMdToken(value.substring(0, index));
            value = value.substring(index + 1).trim();
            if (value.equals("")) {
                value = br.readLine();
                continue;
            }
            listData.add(block);
            StringBuffer currentLine = new StringBuffer(value);
            value = MultiListBuilder.ifNextLineIsContent(currentLine, br);
            HeaderBuilder headerBuilder = new HeaderBuilder(currentLine.toString());
            if (headerBuilder.isRightType()) {
                block.setLineData(headerBuilder.bulid());
            } else {
                block.setLineData(new CommonTextBuilder(currentLine.toString()).bulid());
            }
            if (value == null) break;
            blockType = MultiListBuilder.listType(value);
            blankStr = this.blankStrInHead(value);
            if (value == null) continue;
            if (blankStr.equals(firstBlankStr) && blockType != firstCurrentType) {
                return value;
            }
            if (blankStr.equals(firstBlankStr) && blockType == firstCurrentType) continue;
            if (this.jumpOut(levels, new TypeAndBlank(blankStr, blockType))) {
                return value;
            }
            value = this.buildListBlock(block, value, br, levels);
        }
        return value;
    }

    private static String ifNextLineIsContent(StringBuffer currentLine, BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!MultiListBuilder.isList(line) && !line.trim().equals("")) {
                currentLine = currentLine.append("  \n").append(line);
                continue;
            }
            return line;
        }
        return null;
    }

    private static BlockType listType(String line) {
        if (line == null) {
            return null;
        }
        if (MultiListBuilder.isOrderedList(line)) {
            return BlockType.ORDERED_LIST;
        }
        if (MultiListBuilder.isUnOrderedList(line)) {
            return BlockType.UNORDERED_LIST;
        }
        if (MultiListBuilder.isQuote(line)) {
            return BlockType.QUOTE;
        }
        if (MultiListBuilder.isTodoList(line)) {
            return BlockType.TODO_LIST;
        }
        return null;
    }

    private static int computeCharIndex(String line, BlockType type) {
        if (type == BlockType.ORDERED_LIST || type == BlockType.UNORDERED_LIST) {
            return line.indexOf(" ");
        }
        if (type == BlockType.QUOTE) {
            return line.indexOf(">");
        }
        if (type == BlockType.TODO_LIST) {
            int i = line.indexOf("[ ]");
            if (i == -1) {
                i = line.indexOf("[x]");
            }
            if (i != -1) {
                return i + 3;
            }
        }
        return -1;
    }

    public static boolean isList(String str) {
        return MultiListBuilder.isOrderedList(str) || MultiListBuilder.isUnOrderedList(str) || MultiListBuilder.isQuote(str) || MultiListBuilder.isTodoList(str);
    }

    private static boolean isOrderedList(String str) {
        return Pattern.matches("^[\\d]+\\. [\\d\\D][^\n]*$", str.trim());
    }

    private static boolean isUnOrderedList(String str) {
        return str.trim().startsWith("* ") || str.trim().startsWith("- ") || str.trim().startsWith("+ ");
    }

    private static boolean isQuote(String str) {
        return str.trim().startsWith(">");
    }

    private static boolean isTodoList(String str) {
        return str.trim().startsWith("[ ]") || str.trim().startsWith("[x]");
    }

    @Override
    public boolean isRightType() {
        return false;
    }

    public class TypeAndBlank {
        private String blankStr;
        private BlockType blockType;

        public TypeAndBlank(String blankStr, BlockType blockType) {
            this.blankStr = blankStr;
            this.blockType = blockType;
        }

        public String getBlankStr() {
            return this.blankStr;
        }

        public BlockType getBlockType() {
            return this.blockType;
        }
    }
}

