/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.filter;

import com.youbenzi.mdtool.markdown.bean.Block;
import com.youbenzi.mdtool.markdown.bean.TextOrBlock;
import com.youbenzi.mdtool.markdown.builder.MultiListBuilder;
import com.youbenzi.mdtool.markdown.filter.SyntaxFilter;
import java.util.ArrayList;
import java.util.List;

public class ListFilter
extends SyntaxFilter {
    public ListFilter(SyntaxFilter nextFilter) {
        super(nextFilter);
    }

    @Override
    public List<TextOrBlock> invoke(List<String> lines) {
        ArrayList<TextOrBlock> textOrBlocks = new ArrayList<TextOrBlock>();
        StringBuilder outerText = new StringBuilder();
        int si = lines.size();
        for (int idx = 0; idx < si; ++idx) {
            String str = lines.get(idx);
            if (!this.isListLine(str)) {
                outerText.append(str + "\n");
                continue;
            }
            boolean preLineIsBlank = false;
            StringBuilder interText = new StringBuilder(str).append("\n");
            for (int idx1 = idx + 1; idx1 < si; ++idx1) {
                str = lines.get(idx1);
                if (!str.trim().equals("")) {
                    if (!this.isListLine(str) && preLineIsBlank) {
                        idx = idx1 - 1;
                        break;
                    }
                    interText.append(str).append("\n");
                    preLineIsBlank = false;
                } else {
                    preLineIsBlank = true;
                }
                if (idx1 != si - 1) continue;
                idx = idx1;
            }
            if (!outerText.toString().equals("")) {
                textOrBlocks.add(new TextOrBlock(outerText.toString()));
                outerText = new StringBuilder();
            }
            textOrBlocks.add(new TextOrBlock(this.buildBlock(interText.toString())));
        }
        if (!outerText.toString().equals("")) {
            textOrBlocks.add(new TextOrBlock(outerText.toString()));
        }
        return textOrBlocks;
    }

    protected boolean isListLine(String target) {
        return MultiListBuilder.isList(target);
    }

    protected Block buildBlock(String source) {
        return new MultiListBuilder(source).bulid();
    }
}

