/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.markdown.filter;

import com.youbenzi.mdtool.markdown.TableCellAlign;
import com.youbenzi.mdtool.markdown.bean.TextOrBlock;
import com.youbenzi.mdtool.markdown.builder.TableBuilder;
import com.youbenzi.mdtool.markdown.filter.SyntaxFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TablePartFilter
extends SyntaxFilter {
    public TablePartFilter(SyntaxFilter nextFilter) {
        super(nextFilter);
    }

    @Override
    public List<TextOrBlock> invoke(List<String> lines) {
        ArrayList<TextOrBlock> textOrBlocks = new ArrayList<TextOrBlock>();
        StringBuilder outerText = new StringBuilder();
        int l = lines.size();
        block0: for (int i = 0; i < l; ++i) {
            String str = lines.get(i);
            if (!this.findTableHeader(str)) {
                outerText.append(str + "\n");
                continue;
            }
            if (i + 1 == l) {
                outerText.append(str + "\n");
                break;
            }
            HashMap<Integer, TableCellAlign> cellAligns = new HashMap<Integer, TableCellAlign>();
            if (!this.isTableDataSplitLine(lines.get(i + 1), cellAligns)) {
                outerText.append(str + "\n");
                continue;
            }
            int tableSplitLineNum = i + 1;
            if (!outerText.toString().equals("")) {
                textOrBlocks.add(new TextOrBlock(outerText.toString()));
                outerText = new StringBuilder();
            }
            ArrayList<List<String>> tableDataList = new ArrayList<List<String>>();
            for (int j = i; j < l; ++j) {
                if (j != tableSplitLineNum) {
                    String tableLine = lines.get(j);
                    if (tableLine == null || tableLine.trim().equals("")) {
                        List<List<String>> tableDatas = this.trimTableData(tableDataList);
                        textOrBlocks.add(new TextOrBlock(new TableBuilder(tableDatas, cellAligns).bulid()));
                        i = j - 1;
                        continue block0;
                    }
                    String[] cellDatas = tableLine.split("\\|");
                    tableDataList.add(Arrays.asList(cellDatas));
                }
                if (j != l - 1) continue;
                List<List<String>> tableDatas = this.trimTableData(tableDataList);
                textOrBlocks.add(new TextOrBlock(new TableBuilder(tableDatas, cellAligns).bulid()));
                i = j;
                continue block0;
            }
        }
        if (!outerText.toString().equals("")) {
            textOrBlocks.add(new TextOrBlock(outerText.toString()));
        }
        return textOrBlocks;
    }

    private boolean findTableHeader(String currentLine) {
        String[] tmps;
        if (currentLine.indexOf("|") == -1) {
            return false;
        }
        if (currentLine.startsWith("\\|")) {
            currentLine = currentLine.substring(1);
        }
        if (currentLine.endsWith("\\|")) {
            currentLine = currentLine.substring(0, currentLine.length() - 1);
        }
        return (tmps = currentLine.split("\\|")).length > 1;
    }

    private boolean isTableDataSplitLine(String nextLine, Map<Integer, TableCellAlign> cellAligns) {
        if (nextLine == null || nextLine.trim().equals("")) {
            return false;
        }
        if (nextLine.startsWith("|")) {
            nextLine = nextLine.substring(1);
        }
        if (nextLine.endsWith("|")) {
            nextLine = nextLine.substring(0, nextLine.length() - 1);
        }
        String[] nextParts = nextLine.split("\\|");
        int l = nextParts.length;
        for (int i = 0; i < l; ++i) {
            String part = nextParts[i];
            String tmp = part.trim().replaceAll("-", "");
            if (!(tmp.equals("") || tmp.equals(":") || tmp.equals("::"))) {
                return false;
            }
            if (part.startsWith(":") && part.endsWith(":")) {
                cellAligns.put(i, TableCellAlign.CENTER);
                continue;
            }
            if (part.endsWith(":")) {
                cellAligns.put(i, TableCellAlign.RIGHT);
                continue;
            }
            if (part.startsWith(":")) {
                cellAligns.put(i, TableCellAlign.LEFT);
                continue;
            }
            cellAligns.put(i, TableCellAlign.NONE);
        }
        return true;
    }

    private List<List<String>> trimTableData(List<List<String>> tableDataList) {
        int n;
        int o;
        ArrayList<String> newTmps;
        List<String> tmps;
        int k;
        boolean isFirstEmpty = true;
        boolean isLastEmpty = true;
        int m = tableDataList.size();
        for (k = 0; k < m; ++k) {
            tmps = tableDataList.get(k);
            if (!tmps.get(0).trim().equals("") && isFirstEmpty) {
                isFirstEmpty = false;
            }
            if (tmps.get(tmps.size() - 1).trim().equals("") || !isLastEmpty) continue;
            isLastEmpty = false;
        }
        if (isLastEmpty) {
            m = tableDataList.size();
            for (k = 0; k < m; ++k) {
                tmps = tableDataList.get(k);
                newTmps = new ArrayList<String>();
                o = tmps.size();
                for (n = 0; n < o; ++n) {
                    if (n >= o - 1) continue;
                    newTmps.add(tmps.get(n));
                }
                tableDataList.set(k, newTmps);
            }
        }
        if (isFirstEmpty) {
            m = tableDataList.size();
            for (k = 0; k < m; ++k) {
                tmps = tableDataList.get(k);
                newTmps = new ArrayList();
                o = tmps.size();
                for (n = 0; n < o; ++n) {
                    if (n <= 0) continue;
                    newTmps.add(tmps.get(n));
                }
                tableDataList.set(k, newTmps);
            }
        }
        return tableDataList;
    }
}

