/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.mdtool.tool;

import com.youbenzi.mdtool.export.HTMLDecorator;
import com.youbenzi.mdtool.markdown.Analyzer;
import com.youbenzi.mdtool.markdown.bean.Block;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class MDTool {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static String markdown2Html(File file) throws IOException {
        return MDTool.markdown2Html(file, DEFAULT_CHARSET);
    }

    public static String markdown2Html(File file, String charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String lineStr = null;
            StringBuffer sb = new StringBuffer();
            while ((lineStr = reader.readLine()) != null) {
                sb.append(lineStr).append("\n");
            }
            String string = MDTool.markdown2Html(sb.toString());
            return string;
        }
    }

    public static String markdown2Html(String mdStr) {
        if (mdStr == null) {
            return null;
        }
        List<Block> list = Analyzer.analyze(mdStr);
        HTMLDecorator decorator = new HTMLDecorator();
        decorator.decorate(list);
        return decorator.outputHtml();
    }

    public static void main(String[] args) {
        System.out.println(MDTool.markdown2Html("1. 123\n2. 123123\n\t[ ] 12312\n\t[x] 123123\n\t[ ] 12312\n1. 13123"));
    }
}

