/*
 * Decompiled with CFR 0.152.
 */
package se.transmode.gradle.plugins.docker.client;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import se.transmode.gradle.plugins.docker.client.DockerClient;

public class JavaDockerClient
implements DockerClient {
    private static Logger log = Logging.getLogger(JavaDockerClient.class);
    private com.github.dockerjava.api.DockerClient dockerClient;

    JavaDockerClient(com.github.dockerjava.api.DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }

    public static JavaDockerClient create(String url, String user, String password, String email) {
        DockerClientConfig.DockerClientConfigBuilder configBuilder = DockerClientConfig.createDefaultConfigBuilder();
        if (StringUtils.isEmpty((String)url)) {
            log.info("Connecting to localhost");
        } else {
            log.info("Connecting to {}", (Object)url);
            configBuilder.withUri(url);
        }
        if (StringUtils.isNotEmpty((String)user)) {
            configBuilder.withUsername(user).withPassword(password).withEmail(email);
        }
        return new JavaDockerClient(DockerClientBuilder.getInstance((DockerClientConfig.DockerClientConfigBuilder)configBuilder).build());
    }

    @Override
    public String buildImage(File buildDir, String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Image tag can not be null.");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"Image tag can not be empty.");
        BuildImageResultCallback resultCallback = new BuildImageResultCallback();
        this.dockerClient.buildImageCmd(buildDir).withTag(tag).exec((ResultCallback)resultCallback);
        return resultCallback.awaitImageId();
    }

    @Override
    public void pushImage(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Image tag can not be null.");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"Image tag can not be empty.");
        PushImageResultCallback pushImageResultCallback = (PushImageResultCallback)this.dockerClient.pushImageCmd(tag).exec((ResultCallback)new PushImageResultCallback());
        pushImageResultCallback.awaitSuccess();
    }

    @Override
    public void saveImage(String tag, File toFile) {
        Preconditions.checkNotNull((Object)tag, (Object)"Image tag can not be null.");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"Image tag can not be empty.");
        try (InputStream inputStream = this.dockerClient.saveImageCmd(tag).exec();
             FileOutputStream outputStream = new FileOutputStream(toFile);){
            int length;
            byte[] buffer = new byte[10240];
            while ((length = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, length);
                outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new GradleException("Unable to save image to " + toFile, (Throwable)e);
        }
    }
}

