/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Constants {
    public static final boolean IS_DOT_NET = "true".equals(System.getProperty("yourkit.dot.net", ""));
    public static final boolean IS_EAP = "true".equals(System.getProperty("yourkit.eap", ""));
    public static final String SNAPSHOT_FILE_EXTENSION = ".snapshot";
    public static final String HPROF_SNAPSHOT_FILE_EXTENSION = ".hprof";
    public static final String MEMORY_SNAPSHOT_FILE_EXTENSION = ".memory";
    public static final String CPU_SNAPSHOT_FILE_EXTENSION = ".cpu";
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File SNAPSHOTS_DIR = new File(USER_HOME, "Snapshots");
    public static final File SYSTEM_HOME = new File(USER_HOME, ".yjp");
    public static final String LICENSE_FILE_EXTENSION = ".license";
    public static final File LICENSE_FILE = new File(SYSTEM_HOME, "yjp.license");
    public static final File CONFIG_DIR = new File(SYSTEM_HOME, "config");
    public static final File FILTERS_FOR_AGENT_FILE = new File(CONFIG_DIR, ".filters");
    public static final String OS = System.getProperty("os.name");
    public static final boolean OS_WINDOWS = OS.toLowerCase().startsWith("windows");
    public static final boolean OS_LINUX = OS.toLowerCase().startsWith("linux");
    public static final boolean OS_SOLARIS = OS.toLowerCase().startsWith("sunos");
    public static final boolean OS_MAC = OS.toLowerCase().startsWith("mac os x");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final boolean JAVA_VERSION_1_5_X = JAVA_VERSION.startsWith("1.5");
    public static final boolean JAVA_VERSION_1_6_X = JAVA_VERSION.startsWith("1.6");
    public static final boolean JAVA_VERSION_1_7_X = JAVA_VERSION.startsWith("1.7");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", OS_WINDOWS ? "\r\n" : "\n");
    public static final String PROP_JAVA_VERSION = "java.version";
    public static final String PROP_JAVA_VENDOR = "java.vendor";
    public static final String PROP_DOT_NET_VERSION = "dotnet.version";
    public static final String PROP_AGENT_VERSION = "yjp.agent.version";
    public static final String APP_FULL_NAME = "YourKit Java Profiler 7.0.10";
    public static final String APP_SHORT_NAME = "YourKit Java Profiler";
    public static final String MESSAGE_DLG_TITLE = "YourKit Java Profiler 7.0.10";
    public static final String ERROR_DLG_TITLE = "Error - YourKit Java Profiler 7.0.10";
    public static final String INTERNAL_ERROR_DLG_TITLE = "Internal Error - YourKit Java Profiler 7.0.10";
    public static final int[] DEFAULT_PORTS = new int[]{10001, 10002, 10003, 10004, 10005, 10006, 10007, 10008, 10009, 10010};
    public static int BUILD_NUMBER;
    public static Date BUILD_TIME_STAMP;
    public static final boolean PARANOIC_CHECKS_ENABLED;
    public static final String PROP_JVM_NAME = "java.vm.name";
    public static final String PROP_JVM_VERSION = "java.vm.version";
    public static final String PROP_JVM_VENDOR = "java.vm.vendor";
    public static final String PROP_JVM_INPUT_ARGUMENTS = "yjp.input.arguments";
    public static final String PROP_JVM_CLASS_PATH = "java.class.path";
    public static final String PROP_JVM_LIBRARY_PATH = "java.library.path";
    public static final String PROP_JVM_BOOT_CLASS_PATH = "yjp.boot.class.path";
    public static final String PROP_CLR_VERSION = "yjp.clr.version";
    public static final String PROP_CLR_COMMAND_LINE = "yjp.clr.command.line";
    public static final String PROP_OS_NAME = "os.name";
    public static final String PROP_OS_ARCH = "os.arch";
    public static final String PROP_OS_VERSION = "os.version";
    public static final String PROP_START_TIME = "yjp.vm.starttime";
    public static final String PROP_COLLECTOR_NAME_PREFIX = "collector.name.";
    public static final int AGENT_PROTOCOL_VERSION = 20070719;
    public static final int UI_PROTOCOL_VERSION = 20071015;
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_WITH_PRIMITIVES = 2L;
    public static final long SNAPSHOT_CLR_2_0 = 4L;
    public static final long SNAPSHOT_WITH_COUNTS = 8L;
    public static final long SNAPSHOT_HPROF = 16L;
    public static final long SNAPSHOT_CAUSE_SHUTDOWN = 32L;
    public static final long SNAPSHOT_CAUSE_PERIODIC = 64L;
    public static final long SNAPSHOT_CAUSE_LOW_MEMORY = 128L;
    public static final long SNAPSHOT_CAUSE_OOME = 256L;
    public static final long SNAPSHOT_OIDS_ARE_INDICES = 512L;
    public static final long SNAPSHOT_CLR_1_1 = 1024L;
    public static final int MARKER_TYPE_BIT_JAVA = 1;
    public static final int MARKER_TYPE_BIT_CLR = 2;
    public static final int MARKER_TYPE_BIT_IIS = 4;
    public static final int METHOD_USE_WALL_TIME_BIT = 4;

    static {
        try {
            BUILD_NUMBER = Integer.parseInt("2132");
        }
        catch (Exception e) {
            BUILD_NUMBER = 0;
        }
        try {
            BUILD_TIME_STAMP = new SimpleDateFormat("yyyyMMddkkmm").parse("200801282042");
        }
        catch (Exception e) {
            BUILD_TIME_STAMP = new Date(0L);
        }
        PARANOIC_CHECKS_ENABLED = "true".equals(System.getProperty("yourkit.paranoic.checks", ""));
    }
}

