/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.util.Asserts;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class MarkerFiles {
    public static final String AGENT_PREFIX = ".yjp_20070719_agent";
    public static final String IDE_PLUGIN_PREFIX = ".yjp_ide";
    public static final String PROFILER_UI_PREFIX = ".yjp_20070606_ui";
    public static final String IIS_PREFIX = ".ynp_iis";
    private static File ourMarkersDirCached;
    private static String ourWindowsDir;

    public static File createMarker0(String prefix, int port) throws IOException {
        Asserts.notNull(prefix);
        File marker = MarkerFiles.getMarkerFile(prefix, port);
        marker.createNewFile();
        marker.deleteOnExit();
        return marker;
    }

    public static File getMarkerFile(String prefix, int port) {
        return new File(MarkerFiles.getMarkersDir(), prefix + port);
    }

    public static File createMarker(String prefix, int port) {
        Asserts.notNull(prefix);
        try {
            return MarkerFiles.createMarker0(prefix, port);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static File[] getMarkerFiles(final String prefix) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = MarkerFiles.getMarkersDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().startsWith(prefix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isFile()) continue;
                result.add(file);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    public static void setWindowsDir(String windowsDir) {
        ourWindowsDir = windowsDir;
        ourMarkersDirCached = null;
    }

    public static final File getMarkersDir() {
        if (ourMarkersDirCached != null) {
            return ourMarkersDirCached;
        }
        File alternateDir = null;
        if (Constants.OS_WINDOWS) {
            File dir;
            if (ourWindowsDir != null && (dir = new File(ourWindowsDir, "temp")).isDirectory() && dir.canWrite()) {
                alternateDir = new File(dir, ".yjp");
            }
        } else {
            File dir = new File("/tmp");
            if (dir.isDirectory() && dir.canWrite()) {
                alternateDir = dir;
            }
        }
        ourMarkersDirCached = alternateDir != null ? alternateDir : Constants.SYSTEM_HOME;
        return ourMarkersDirCached;
    }
}

