/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.Constants;
import com.yourkit.api.ControllerImpl;
import java.lang.reflect.Field;

public final class Controller {
    private final ControllerImpl myImpl;
    public static final String DEFAULT_FILTERS = "com.sun.*\njava.*\njavax.*\nsun.*\njrockit.*";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(String host, int port) throws Exception {
        Controller.checkJdk();
        this.myImpl = new ControllerImpl(host, port);
    }

    public String getHost() {
        return this.myImpl.getHost();
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            Integer i = (Integer)field.get(null);
            port = i;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    public String captureSnapshot(long snapshotFlags) throws Exception {
        Controller.checkJdk();
        return this.myImpl.captureSnapshot(snapshotFlags, null);
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public void startAllocationRecording(long mode) throws Exception {
        this.myImpl.startAllocationRecording(mode);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.myImpl.startCPUProfiling(mode, filters);
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void advanceGeneration(String description) {
        this.myImpl.markMemory(2, description == null ? "" : description);
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    static void checkJdk() {
        if (Constants.JAVA_VERSION.compareTo("1.4") < 0) {
            throw new RuntimeException("YourKit Java Profiler API requires Java 1.4 or newer");
        }
    }
}

