/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Asserts;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public final class Strings {
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    public static String replace(String text, String oldSubstring, String newSubstring) {
        if (text.length() < oldSubstring.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int i1 = text.indexOf(oldSubstring, i);
            if (i1 < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text.substring(i));
                break;
            }
            if (newText == null) {
                newText = new StringBuilder();
            }
            newText.append(text.substring(i, i1));
            newText.append(newSubstring);
            i = i1 + oldSubstring.length();
        }
        return newText != null ? newText.toString() : "";
    }

    public static String decapitalize(String original) {
        Asserts.notNull(original);
        StringBuilder result = new StringBuilder(original.length());
        StringTokenizer tokenizer = new StringTokenizer(original, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (result.length() == 0) {
                result.append(word);
                continue;
            }
            result.append(' ');
            if (word.equals("Microsoft") || word.equals("Visual") || word.equals("Studio")) {
                result.append(word);
                continue;
            }
            if (word.length() >= 2 && Character.isUpperCase(word.charAt(0)) && !Character.isUpperCase(word.charAt(1))) {
                result.append(word.toLowerCase());
                continue;
            }
            result.append(word);
        }
        return result.toString();
    }

    public static boolean startsWithIgnoreCase(String original, String prefix) {
        int prefixLength = prefix.length();
        if (original.length() < prefixLength) {
            return false;
        }
        int offset = 0;
        int prefixOffset = 0;
        while (--prefixLength >= 0) {
            if (Character.toLowerCase(original.charAt(offset++)) == Character.toLowerCase(prefix.charAt(prefixOffset++))) continue;
            return false;
        }
        return true;
    }

    public static String removeComments(String original) {
        boolean inComment = false;
        StringBuilder builder = new StringBuilder();
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                if (inComment) break;
                builder.append(original.charAt(i));
                break;
            }
            String symbols = original.substring(i, i + 2);
            if ("/*".equals(symbols)) {
                if (!inComment) {
                    inComment = true;
                    ++i;
                    continue;
                }
            } else if ("*/".equals(symbols) && inComment) {
                inComment = false;
                ++i;
                continue;
            }
            if (inComment) continue;
            builder.append(original.charAt(i));
        }
        return builder.toString();
    }

    public static String toHex(byte v) {
        return Strings.toHex(v, 2);
    }

    public static String toHex(char v) {
        return Strings.toHex(v, 4);
    }

    public static String toHex(short v) {
        return Strings.toHex(v, 4);
    }

    public static String toHex(int v) {
        return Strings.toHex(v, 8);
    }

    public static String toHex(long v) {
        return Strings.toHex(v, 16);
    }

    public static String toHex(long v, int hexDigits) {
        char[] buffer = new char[hexDigits];
        long _v = v;
        for (int i = hexDigits - 1; i >= 0; --i) {
            buffer[i] = DIGITS[(int)_v & 0xF];
            _v >>= 4;
        }
        return new String(buffer);
    }

    public static final byte[] getUTF8Bytes(String s) {
        Asserts.notNull(s);
        try {
            return s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getDigitCountInDecimalPresentation(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negatives not allowed: " + value);
        }
        int result = 0;
        int rest = value;
        do {
            ++result;
        } while ((rest /= 10) > 0);
        return result;
    }
}

