/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.Constants;
import com.yourkit.api.ControllerImpl;
import java.lang.reflect.Field;

public final class Controller {
    private final ControllerImpl myImpl;
    public static final String DEFAULT_FILTERS = "com.sun.*\njava.*\njavax.*\nsun.*\njrockit.*";
    private static final String CMD_PRINT_STATUS = "print-current-status";
    private static final String CMD_CAPTURE_PERFORMANCE_SNAPSHOT = "capture-performance-snapshot";
    private static final String CMD_CAPTURE_MEMORY_SNAPSHOT = "capture-memory-snapshot";
    private static final String CMD_START_CPU_SAMPLING = "start-cpu-sampling";
    private static final String CMD_STOP_CPU_PROFILING = "stop-cpu-profiling";
    private static final String CMD_START_ALLOC_ALL = "start-alloc-recording-all";
    private static final String CMD_START_ALLOC_ADAPTIVE = "start-alloc-recording-adaptive";
    private static final String CMD_STOP_ALLOC = "stop-alloc-recording";
    private static final String CMD_START_MONITOR_PROFILING = "start-monitor-profiling";
    private static final String CMD_STOP_MONITOR_PROFILING = "stop-monitor-profiling";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(String host, int port) throws Exception {
        Controller.checkJdk();
        this.myImpl = new ControllerImpl(host, port);
    }

    public String getHost() {
        return this.myImpl.getHost();
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            Integer i = (Integer)field.get(null);
            port = i;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    public String captureSnapshot(long snapshotFlags) throws Exception {
        Controller.checkJdk();
        if (snapshotFlags != 0L && snapshotFlags != 1L) {
            throw new IllegalArgumentException("snapshotFlags should be either ProfilingModes.SNAPSHOT_WITHOUT_HEAP or ProfilingModes.SNAPSHOT_WITH_HEAP");
        }
        return this.myImpl.captureSnapshot(snapshotFlags, null);
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public void startAllocationRecording(long mode) throws Exception {
        this.myImpl.startAllocationRecording(mode);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.myImpl.startCPUProfiling(mode, filters);
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void advanceGeneration(String description) {
        this.myImpl.markMemory(2, description == null ? "" : description);
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    static void checkJdk() {
        if (Constants.JAVA_VERSION.compareTo("1.4") < 0) {
            throw new RuntimeException("YourKit Java Profiler API requires Java 1.4 or newer");
        }
    }

    private static void printHelp() {
        System.out.println("YourKit Java Profiler 7.0.6 command line tools\n\nUsage: java -cp yjp-controller-api-redist.jar com.yourkit.api.Controller <command> <host> <port>\n\nwhere <command> is one of:\n\nprint-current-status\ncapture-memory-snapshot\ncapture-performance-snapshot\nstart-cpu-sampling\nstop-cpu-profiling\nstart-alloc-recording-all\nstart-alloc-recording-adaptive\nstop-alloc-recording\nstart-monitor-profiling\nstop-monitor-profiling\n\nExample: java -cp yjp-controller-api-redist.jar com.yourkit.api.Controller capture-memory-snapshot localhost 10001\n");
    }

    public static void main(String[] args) throws Exception {
        int port;
        if (args.length != 3) {
            Controller.printHelp();
            return;
        }
        String command = args[0].toLowerCase();
        String host = args[1];
        String portStr = args[2];
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            System.out.println("Error: invalid port number specified: " + portStr);
            Controller.printHelp();
            return;
        }
        if (CMD_CAPTURE_MEMORY_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            String path = controller.captureSnapshot(1L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_PERFORMANCE_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            String path = controller.captureSnapshot(0L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_START_CPU_SAMPLING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCPUProfiling(36L, "");
            System.out.println("CPU sampling started");
            return;
        }
        if (CMD_STOP_CPU_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopCPUProfiling();
            System.out.println("CPU profiling stopped");
            return;
        }
        if (CMD_START_ALLOC_ALL.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(2L);
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_START_ALLOC_ADAPTIVE.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(66L);
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_STOP_ALLOC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopAllocationRecording();
            System.out.println("Allocation recording stopped");
            return;
        }
        if (CMD_START_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startMonitorProfiling();
            System.out.println("Monitor profiling started");
            return;
        }
        if (CMD_STOP_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopMonitorProfiling();
            System.out.println("Monitor profiling stopped");
            return;
        }
        if (CMD_PRINT_STATUS.equals(command)) {
            Controller controller = new Controller(host, port);
            long status = controller.getStatus();
            if ((status & 0x42L) != 0L) {
                System.out.println("Allocation recording is on (adaptive)");
            } else if ((status & 2L) != 0L) {
                System.out.println("Allocation recording is on (all objects)");
            } else {
                System.out.println("Allocation recording is off");
            }
            if ((status & 0xCL) != 0L) {
                System.out.println("CPU profiling is on (tracing)");
            } else if ((status & 4L) != 0L) {
                System.out.println("CPU profiling is on (sampling)");
            } else {
                System.out.println("CPU profiling is off");
            }
            if ((status & 0x80L) != 0L) {
                System.out.println("Monitor profiling is on");
            } else {
                System.out.println("Monitor profiling is off");
            }
            return;
        }
        Controller.printHelp();
    }
}

