/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.util.Asserts;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Agent {
    public static final long CAPABILITY_CAN_RECORD_METHOD_INVOCATION_COUNTS = 64L;
    public static final long CAPABILITY_CAN_CAPTURE_ON_USED_MEMORY_THRESHOLD = 128L;
    public static final long CAPABILITY_CAN_RECORD_ALLOCATIONS = 256L;
    public static final long CAPABILITY_CAN_CAPTURE_PERIODICALLY = 2048L;
    public static final long CAPABILITY_CAN_RECORD_J2EE = 4096L;
    public static final long CAPABILITY_JVM_CLASS_INSTANCE_STATISTICS = 8192L;
    public static final long CAPABILITY_JVM_MONITOR_PROFILING = 16384L;
    public static final long CAPABILITY_CLR_2_0 = 32768L;
    public static final long CAPABILITY_CLR_TRACING = 65536L;
    public static final long CAPABILITY_CAN_WRITE_PRIMITIVE_VALUES = 131072L;

    public static File suggestSnapshotFile(File directory, String sessionName, String fileNamePostfix, String fileExtension) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Asserts.notNull(sessionName);
        Asserts.notNull(fileExtension);
        StringBuffer result = new StringBuffer();
        if (sessionName.length() > 0) {
            result.append(Agent.sessionNameToFileNamePart(sessionName));
            result.append('-');
        }
        result.append(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        if (fileNamePostfix != null) {
            result.append('-').append(fileNamePostfix);
        }
        return Agent.suggestSnapshotFile(directory, result.toString(), fileExtension);
    }

    public static File suggestSnapshotFile(File directory, String fileNamePrefix, String fileExtension) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Asserts.notNull(fileNamePrefix);
        Asserts.notNull(fileExtension);
        File[] files = directory.listFiles();
        if (files == null) {
            int index = 0;
            while (true) {
                String fileName;
                File result;
                if (!(result = new File(directory, fileName = fileNamePrefix + (index == 0 ? "" : "(" + index + ")") + fileExtension)).exists()) {
                    return result;
                }
                ++index;
            }
        }
        int maxFound = -1;
        String start = fileNamePrefix + "(";
        String nameWithoutNumber = fileNamePrefix + fileExtension;
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (name.equals(nameWithoutNumber)) {
                maxFound = Math.max(maxFound, 0);
                continue;
            }
            String end = ")" + fileExtension;
            if (!name.startsWith(start) || !name.endsWith(end)) continue;
            String numberStr = name.substring(start.length(), name.length() - end.length());
            try {
                int value = Integer.parseInt(numberStr);
                maxFound = Math.max(value, maxFound);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String fileName = fileNamePrefix + (++maxFound == 0 ? "" : "(" + maxFound + ")") + fileExtension;
        return new File(directory, fileName);
    }

    public static String sessionNameToFileNamePart(String sessionName) {
        StringBuffer result = new StringBuffer(sessionName.length());
        for (int i = 0; i < sessionName.length(); ++i) {
            char ch = sessionName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '.') {
                result.append(ch);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }
}

