/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.runtime.PresentableException;
import com.yourkit.runtime.Protocol;
import com.yourkit.util.Asserts;
import com.yourkit.util.Strings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Packet {
    private static final long MAGIC = 123456789L;

    private Packet() {
    }

    public static void writeHeader(DataOutputStream stream, int packetType) throws IOException {
        Packet.writeLong(stream, 123456789L);
        Packet.writeInt(stream, packetType);
    }

    public static int readHeader(DataInputStream stream, String incompatibleVersionErrorMessage) throws IOException {
        long magic = stream.readLong();
        if (123456789L != magic) {
            throw new IOException("Invalid header magic number:" + magic);
        }
        int packetType = stream.readInt();
        if (packetType == 0) {
            String error = Packet.readString(stream);
            if (error != null && error.startsWith("Unknown packet type:")) {
                throw new PresentableException(incompatibleVersionErrorMessage, error);
            }
            throw new PresentableException(error);
        }
        return packetType;
    }

    public static void readHeaderWithStandardResponse(DataInputStream stream) throws IOException {
        Packet.readHeader(stream, 1, Protocol.INCOMPATIBLE_AGENT_MESSAGE);
    }

    public static void readHeader(DataInputStream stream, int expectedPacketType, String incompatibleVersionErrorMessage) throws IOException {
        int packetType = Packet.readHeader(stream, incompatibleVersionErrorMessage);
        if (packetType != expectedPacketType) {
            throw new PresentableException(incompatibleVersionErrorMessage, "Wrong packet type: " + packetType + ", expected " + expectedPacketType);
        }
    }

    public static void writeInt(DataOutputStream stream, int value) throws IOException {
        stream.writeInt(value);
    }

    public static int readInt(DataInputStream stream) throws IOException {
        return stream.readInt();
    }

    public static void writeBytes(DataOutputStream stream, byte[] bytes, int length) throws IOException {
        Asserts.notNull(bytes);
        stream.write(bytes, 0, length);
    }

    public static int readBytes(DataInputStream stream, byte[] bytes) throws IOException {
        Asserts.notNull(bytes);
        return stream.read(bytes);
    }

    public static void writeLong(DataOutputStream stream, long value) throws IOException {
        stream.writeLong(value);
    }

    public static long readLong(DataInputStream stream) throws IOException {
        return stream.readLong();
    }

    public static void writeString(DataOutputStream stream, String string) throws IOException {
        if (string == null) {
            stream.writeInt(-1);
        } else {
            byte[] utf = Strings.getUTF8Bytes(string);
            stream.writeInt(utf.length);
            for (int i = 0; i < utf.length; ++i) {
                stream.writeByte(utf[i]);
            }
        }
    }

    public static String readString(DataInputStream stream) throws IOException {
        byte[] utf;
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length < 0) {
            throw new PresentableException(Protocol.INCORRECT_DATA_MESSAGE, "Negative string length: " + length);
        }
        try {
            utf = new byte[length];
        }
        catch (OutOfMemoryError e) {
            throw new PresentableException(Protocol.INCORRECT_DATA_MESSAGE, "Cannot allocate " + length + " bytes");
        }
        for (int i = 0; i < utf.length; ++i) {
            utf[i] = stream.readByte();
        }
        return new String(utf, "utf-8");
    }

    public static String readStringNotNull(DataInputStream stream) throws IOException {
        String s = Packet.readString(stream);
        if (s == null) {
            throw new PresentableException(Protocol.INCORRECT_DATA_MESSAGE, "Unexpected null string");
        }
        return s;
    }

    public static void flush(DataOutputStream stream) throws IOException {
        stream.flush();
    }
}

