/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.ControllerImpl;
import java.lang.reflect.Field;

public final class Controller {
    private final ControllerImpl myImpl;
    public static final String DEFAULT_FILTERS = "com.sun.*\njava.*\njavax.*\nsun.*\njrockit.*";
    public static final String DEFAULT_WALLTIME_SPEC = "# Format:\n# <fully qualified class name> <method name> <method signature>\n# Wildcards ('*') are accepted.\n# See for detail: http://www.yourkit.com/docs/75/help/times.jsp\n\njava.io.RandomAccessFile    readBytes    ([BII)I\njava.io.RandomAccessFile    read         ()I\njava.io.RandomAccessFile    write        (I)V\njava.io.RandomAccessFile    writeBytes   ([BII)V\njava.net.SocketInputStream  socketRead0  (Ljava/io/FileDescriptor;[BIII)I\njava.net.SocketOutputStream socketWrite0 (Ljava/io/FileDescriptor;[BII)V\n";
    private static final String CMD_PRINT_STATUS = "print-current-status";
    private static final String CMD_CAPTURE_PERFORMANCE_SNAPSHOT = "capture-performance-snapshot";
    private static final String CMD_CAPTURE_MEMORY_SNAPSHOT = "capture-memory-snapshot";
    private static final String CMD_START_CPU_SAMPLING = "start-cpu-sampling";
    private static final String CMD_START_CPU_TRACING = "start-cpu-tracing";
    private static final String CMD_NOJ2EE = "noj2ee";
    private static final String CMD_STOP_CPU_PROFILING = "stop-cpu-profiling";
    private static final String CMD_START_ALLOC_ALL = "start-alloc-recording-all";
    private static final String CMD_START_ALLOC_ADAPTIVE = "start-alloc-recording-adaptive";
    private static final String CMD_STOP_ALLOC = "stop-alloc-recording";
    private static final String CMD_START_MONITOR_PROFILING = "start-monitor-profiling";
    private static final String CMD_STOP_MONITOR_PROFILING = "stop-monitor-profiling";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(String host, int port) throws Exception {
        this.myImpl = new ControllerImpl(host, port);
    }

    public String getHost() {
        return this.myImpl.getHost();
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            Integer i = (Integer)field.get(null);
            port = i;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    public String captureSnapshot(long snapshotFlags) throws Exception {
        if (snapshotFlags != 0L && snapshotFlags != 1L && snapshotFlags != 17L) {
            throw new IllegalArgumentException("illegal snapshotFlags value " + snapshotFlags + "; should be one of ProfilingModes.SNAPSHOT_xxx");
        }
        return this.myImpl.captureSnapshot(snapshotFlags, null);
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public void startAllocationRecording(boolean recordEachEnabled, int recordEach, boolean sizeLimitEnabled, int sizeLimit) throws Exception {
        this.myImpl.startAllocationRecording(recordEachEnabled, recordEach, sizeLimitEnabled, sizeLimit);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.startCPUProfiling(mode, filters, DEFAULT_WALLTIME_SPEC);
    }

    public void startCPUProfiling(long mode, String filters, String wallTimeSpec) throws Exception {
        this.myImpl.startCPUProfiling(mode, filters, null);
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void enableStackTelemetry() throws Exception {
        this.myImpl.enableStackTelemetry();
    }

    public void disableStackTelemetry() throws Exception {
        this.myImpl.disableStackTelemetry();
    }

    public void advanceGeneration(String description) {
        this.myImpl.markMemory(2, description == null ? "" : description);
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    private static void printHelp() {
        System.out.println("YourKit Java Profiler 8.0.1 command line tools\n\nUsage: java -jar yjp-controller-api-redist.jar <host> <port> <command>\n\nwhere <command> is one of:\n\nprint-current-status\ncapture-memory-snapshot\ncapture-performance-snapshot\nstart-cpu-sampling [noj2ee]\nstart-cpu-tracing [noj2ee]\nstop-cpu-profiling\nstart-alloc-recording-all  // record each allocation\nstart-alloc-recording-adaptive // record each 10th allocation, and all objects with size > 1M\nstop-alloc-recording\nstart-monitor-profiling\nstop-monitor-profiling\n\nExamples:\njava -jar yjp-controller-api-redist.jar localhost 10001 capture-memory-snapshot\njava -jar yjp-controller-api-redist.jar localhost 10001 start-cpu-sampling\njava -jar yjp-controller-api-redist.jar localhost 10001 start-cpu-sampling noj2ee\n");
    }

    public static void main(String[] args) throws Exception {
        int port;
        if (args.length != 3 && args.length != 4) {
            Controller.printHelp();
            return;
        }
        String host = args[0];
        String portStr = args[1];
        String command = args[2].toLowerCase();
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            System.out.println("Error: invalid port number specified: " + portStr);
            Controller.printHelp();
            return;
        }
        if (args.length == 3) {
            if (CMD_CAPTURE_MEMORY_SNAPSHOT.equals(command)) {
                Controller controller = new Controller(host, port);
                String path = controller.captureSnapshot(1L);
                System.out.println("Snapshot captured: " + path);
                return;
            }
            if (CMD_CAPTURE_PERFORMANCE_SNAPSHOT.equals(command)) {
                Controller controller = new Controller(host, port);
                String path = controller.captureSnapshot(0L);
                System.out.println("Snapshot captured: " + path);
                return;
            }
            if (CMD_START_CPU_SAMPLING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startCPUProfiling(36L, DEFAULT_FILTERS);
                System.out.println("CPU sampling started");
                return;
            }
            if (CMD_START_CPU_TRACING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startCPUProfiling(44L, DEFAULT_FILTERS);
                System.out.println("CPU tracing started");
                return;
            }
            if (CMD_STOP_CPU_PROFILING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.stopCPUProfiling();
                System.out.println("CPU profiling stopped");
                return;
            }
            if (CMD_START_ALLOC_ALL.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startAllocationRecording(true, 1, false, 0);
                System.out.println("Allocation recording started");
                return;
            }
            if (CMD_START_ALLOC_ADAPTIVE.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startAllocationRecording(true, 10, true, 0x100000);
                System.out.println("Allocation recording started");
                return;
            }
            if (CMD_STOP_ALLOC.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.stopAllocationRecording();
                System.out.println("Allocation recording stopped");
                return;
            }
            if (CMD_START_MONITOR_PROFILING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startMonitorProfiling();
                System.out.println("Monitor profiling started");
                return;
            }
            if (CMD_STOP_MONITOR_PROFILING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.stopMonitorProfiling();
                System.out.println("Monitor profiling stopped");
                return;
            }
            if (CMD_PRINT_STATUS.equals(command)) {
                Controller controller = new Controller(host, port);
                long status = controller.getStatus();
                if ((status & 2L) != 0L) {
                    System.out.println("Allocation recording is on");
                } else {
                    System.out.println("Allocation recording is off");
                }
                if ((status & 0xCL) == 12L) {
                    System.out.println("CPU profiling is on (tracing)");
                } else if ((status & 4L) != 0L) {
                    System.out.println("CPU profiling is on (sampling)");
                } else {
                    System.out.println("CPU profiling is off");
                }
                if ((status & 0x80L) != 0L) {
                    System.out.println("Monitor profiling is on");
                } else {
                    System.out.println("Monitor profiling is off");
                }
                return;
            }
        }
        if (args.length == 4 && CMD_NOJ2EE.equals(args[3])) {
            if (CMD_START_CPU_SAMPLING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startCPUProfiling(4L, DEFAULT_FILTERS);
                System.out.println("CPU sampling started");
                return;
            }
            if (CMD_START_CPU_TRACING.equals(command)) {
                Controller controller = new Controller(host, port);
                controller.startCPUProfiling(12L, DEFAULT_FILTERS);
                System.out.println("CPU tracing started");
                return;
            }
        }
        Controller.printHelp();
    }
}

