/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.Constants;
import com.yourkit.util.Asserts;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class Agent {
    public static final long CAPABILITY_CAN_TRACE = 64L;
    public static final long CAPABILITY_CAN_CAPTURE_ON_USED_MEMORY_THRESHOLD = 128L;
    public static final long CAPABILITY_CAN_RECORD_ALLOCATIONS = 256L;
    public static final long CAPABILITY_MEMORY_PROFILING = 512L;
    public static final long CAPABILITY_ATTACHED_AGENT = 1024L;
    public static final long CAPABILITY_CAN_CAPTURE_PERIODICALLY = 2048L;
    public static final long CAPABILITY_CAN_RECORD_J2EE = 4096L;
    private static final boolean USE_PARENTHESES = Constants.OS_WINDOWS;

    public static File suggestSnapshotFile(File directory, String sessionName, String fileNamePostfix, String fileExtension) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Asserts.notNull(sessionName);
        Asserts.notNull(fileExtension);
        StringBuffer result = new StringBuffer();
        if (sessionName.length() > 0) {
            result.append(Agent.sessionNameToFileNamePart(sessionName));
            result.append('-');
        }
        result.append(new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(new Date()));
        if (fileNamePostfix != null) {
            result.append('-').append(fileNamePostfix);
        }
        return Agent.suggestSnapshotFile(directory, result.toString(), fileExtension);
    }

    private static String getFileName(String fileNamePrefix, int index, String fileExtension) {
        if (index == 0) {
            return fileNamePrefix + fileExtension;
        }
        if (USE_PARENTHESES) {
            return fileNamePrefix + "(" + index + ")" + fileExtension;
        }
        return fileNamePrefix + "-" + index + fileExtension;
    }

    public static File suggestSnapshotFile(File directory, String fileNamePrefix, String fileExtension) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Asserts.notNull(fileNamePrefix);
        Asserts.notNull(fileExtension);
        File[] files = directory.listFiles();
        if (files == null) {
            int index = 0;
            while (true) {
                String fileName;
                File result;
                if (!(result = new File(directory, fileName = Agent.getFileName(fileNamePrefix, index, fileExtension))).exists()) {
                    return result;
                }
                ++index;
            }
        }
        int maxFound = -1;
        String start = USE_PARENTHESES ? fileNamePrefix + "(" : fileNamePrefix + "-";
        String end = USE_PARENTHESES ? ")" + fileExtension : fileExtension;
        String nameWithoutNumber = Agent.getFileName(fileNamePrefix, 0, fileExtension);
        for (File file : files) {
            String name = file.getName();
            if (name.equals(nameWithoutNumber)) {
                maxFound = Math.max(maxFound, 0);
                continue;
            }
            if (!name.startsWith(start) || !name.endsWith(end)) continue;
            String numberStr = name.substring(start.length(), name.length() - end.length());
            try {
                int value = Integer.parseInt(numberStr);
                maxFound = Math.max(value, maxFound);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String fileName = Agent.getFileName(fileNamePrefix, maxFound + 1, fileExtension);
        return new File(directory, fileName);
    }

    private static String sessionNameToFileNamePart(String sessionName) {
        StringBuffer result = new StringBuffer(sessionName.length());
        for (int i = 0; i < sessionName.length(); ++i) {
            char ch = sessionName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '.') {
                result.append(ch);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }
}

