/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

public final class Asserts {
    private Asserts() {
    }

    public static void isNull(Object obj) {
        if (obj != null) {
            throw new IllegalArgumentException("value should be null");
        }
    }

    public static void notNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
    }

    public static void arrayFilled(Object[] array) {
        Asserts.notNull(array);
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("array contains null at " + i + "; length=" + array.length);
        }
    }

    public static void assertTrue(boolean b) {
        if (!b) {
            throw new IllegalArgumentException("assertion failed");
        }
    }

    public static void assertFalse(boolean b) {
        if (b) {
            throw new IllegalArgumentException("assertion failed");
        }
    }

    public static void assertEqual(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(long a, long b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(double a, double b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(float a, float b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void assertEqual(boolean a, boolean b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    private static boolean equalsNullable(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public static void assertEqual(Object a, Object b) {
        if (!Asserts.equalsNullable(a, b)) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }
}

